/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.extension;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.browsing.ui.common.extension.ContributorBindingImpl;
import org.simantics.browsing.ui.common.extension.internal.ContributorBindingExtension;
import org.simantics.browsing.ui.common.extension.internal.ContributorImplementationBinding;
import org.simantics.browsing.ui.common.extension.internal.ContributorReferenceBinding;
import org.simantics.browsing.ui.content.Contributor;
import org.simantics.browsing.ui.content.ContributorBinding;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.utils.strings.StringUtils;

public abstract class ContributorBindingExtensionManager<Factory>
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private ExtensionTracker tracker;
    private static final OntologyVersions VERSIONS = OntologyVersions.getInstance();
    private ContributorBindingExtension<Factory>[] extensions = new ContributorBindingExtension[0];

    abstract String getExtensionPointName();

    ContributorBindingExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, this.getExtensionPointName());
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new ContributorBindingExtension[0];
    }

    public ContributorBindingExtension<Factory>[] getExtensions() {
        return this.extensions;
    }

    abstract ContributorReferenceBinding<Factory> createReferenceBinding(double var1, String var3, String var4);

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<ContributorBindingExtension<Factory>> newExtensions = new HashSet<ContributorBindingExtension<Factory>>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ContributorBindingExtension<Factory> ext;
            double preference;
            IConfigurationElement child;
            IConfigurationElement el = iConfigurationElementArray[n2];
            String browseContext = VERSIONS.currentVersion(StringUtils.safeString((String)el.getAttribute("browseContext")));
            IConfigurationElement[] iConfigurationElementArray2 = el.getChildren("reference");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                preference = StringUtils.safeDouble((String)child.getAttribute("preference"));
                String factoryId = StringUtils.safeString((String)child.getAttribute("id"));
                ext = this.createReferenceBinding(preference, browseContext, factoryId);
                this.tracker.registerObject(el.getDeclaringExtension(), ext, 0);
                newExtensions.add(ext);
                ++n4;
            }
            iConfigurationElementArray2 = el.getChildren("implementation");
            n3 = iConfigurationElementArray2.length;
            n4 = 0;
            while (n4 < n3) {
                child = iConfigurationElementArray2[n4];
                preference = StringUtils.safeDouble((String)child.getAttribute("preference"));
                try {
                    Contributor factory = (Contributor)child.createExecutableExtension("class");
                    ext = new ContributorImplementationBinding(preference, browseContext, factory);
                    this.tracker.registerObject(el.getDeclaringExtension(), ext, 0);
                    newExtensions.add(ext);
                }
                catch (CoreException e) {
                    System.out.println(" == Could not load ViewpointContributionFactory '" + child.getAttribute("class") + "' due to the following error: " + e.getMessage());
                }
                ++n4;
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new ContributorBindingExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<ContributorBindingExtension<Factory>> newExtensions = new HashSet<ContributorBindingExtension<Factory>>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new ContributorBindingExtension[newExtensions.size()]);
    }

    public Set<ContributorBinding<Factory>> getBoundContributions(Set<String> browseContexts) {
        HashSet<ContributorBinding<Factory>> result = new HashSet<ContributorBinding<Factory>>();
        ContributorBindingExtension<Factory>[] contributorBindingExtensionArray = this.getExtensions();
        int n = contributorBindingExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Contributor<Factory> factory;
            ContributorBindingExtension<Factory> binding = contributorBindingExtensionArray[n2];
            if (browseContexts.contains(binding.getBrowseContext()) && (factory = binding.getFactory()) != null) {
                result.add(new ContributorBindingImpl<Factory>(binding.getPreference(), factory));
            }
            ++n2;
        }
        return result;
    }
}

