/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.representation.representations;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.representation.StringRepresentation2;

public class DefaultStringRepresentation2
implements StringRepresentation2 {
    private static final int MAX_ARRAY_VALUE_LENGTH_SHOWN = 32;
    Resource r;
    static Binding dataTypeBinding = Bindings.getBindingUnchecked(Datatype.class);

    public DefaultStringRepresentation2(Resource r) {
        this.r = r;
    }

    @Override
    public String get(ReadGraph g) throws DatabaseException {
        return DefaultStringRepresentation2.fullValueToString(g, this.r);
    }

    @Override
    public String get(ReadGraph g, int index) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        if (g.isInstanceOf(this.r, L0.OrderedSet)) {
            List l = OrderedSetUtils.toList((ReadGraph)g, (Resource)this.r);
            return DefaultStringRepresentation2.fullValueToString(g, (Resource)l.get(index));
        }
        Object value = g.getValue(this.r);
        return Array.get(value, index).toString();
    }

    @Override
    public String get(ReadGraph g, int start, int size) throws DatabaseException {
        Object value = g.getValue(this.r);
        int valueSize = Array.getLength(value);
        int end = start + size;
        if (start > valueSize || end > valueSize) {
            throw new IndexOutOfBoundsException("value size is " + valueSize + ", requested range [" + start + "-" + (end - 1) + "]");
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        int i = start;
        while (i < end) {
            if (!first) {
                b.append(',');
            }
            first = false;
            b.append(Array.get(value, i));
            ++i;
        }
        return b.toString();
    }

    @Override
    public int getArraySize(ReadGraph g) {
        try {
            Object value = g.getValue(this.r);
            return Array.getLength(value);
        }
        catch (DatabaseException databaseException) {
            return -1;
        }
    }

    public static String fullValueToString(ReadGraph graph, Resource resource) throws ValidationException, ServiceException, BindingException {
        Object representation = null;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, L0.Relation)) {
            representation = (String)graph.getPossibleRelatedValue(resource, L0.HasLabel);
            if (representation == null) {
                representation = (String)graph.getPossibleRelatedValue(resource, L0.HasName);
            }
            if (representation == null) {
                Resource single;
                Resource inverse = graph.getPossibleInverse(resource);
                if (inverse != null) {
                    representation = (String)graph.getPossibleRelatedValue(resource, L0.HasLabel);
                    if (representation == null) {
                        representation = (String)graph.getPossibleRelatedValue(inverse, L0.HasName);
                    }
                    if (representation != null) {
                        representation = "Inverse Of " + (String)representation;
                    }
                }
                if (representation == null && (single = graph.getPossibleObject(resource, L0.SubrelationOf)) != null) {
                    String singleValue = DefaultStringRepresentation2.fullValueToString(graph, single);
                    representation = "<R " + singleValue;
                }
            }
        }
        if (representation == null) {
            try {
                if (graph.isInstanceOf(resource, L0.Literal)) {
                    representation = DefaultStringRepresentation2.literalStr(graph, resource);
                } else {
                    boolean first = true;
                    for (Resource label : graph.getObjects(resource, L0.HasLabel)) {
                        if (!first) {
                            representation = (String)representation + ", ";
                        } else {
                            first = false;
                        }
                        if (!graph.isInstanceOf(label, L0.Literal)) continue;
                        representation = DefaultStringRepresentation2.literalStr(graph, label);
                    }
                    if (representation == null) {
                        for (Resource name : graph.getObjects(resource, L0.HasName)) {
                            if (!first) {
                                representation = (String)representation + ", ";
                            } else {
                                first = false;
                            }
                            representation = DefaultStringRepresentation2.literalStr(graph, name);
                        }
                    }
                    if (representation == null) {
                        representation = ": ";
                        first = true;
                        for (Resource t : graph.getPrincipalTypes(resource)) {
                            String typeName = (String)graph.getPossibleRelatedValue(t, L0.HasName);
                            if (typeName == null) {
                                typeName = "[unnamed type]";
                            }
                            if (first) {
                                first = false;
                            } else {
                                representation = (String)representation + ", ";
                            }
                            representation = (String)representation + typeName;
                        }
                    }
                }
            }
            catch (DoesNotContainValueException e) {
                throw new ValidationException((Throwable)e);
            }
        }
        return representation;
    }

    private static String constrainString(String str, int maxLen) {
        if (str.length() > maxLen) {
            return str.substring(0, maxLen - 3) + "...";
        }
        return str;
    }

    private static String literalStr(ReadGraph graph, Resource resource) throws DoesNotContainValueException, ValidationException, ServiceException, BindingException {
        return DefaultStringRepresentation2.constrainString(DefaultStringRepresentation2.literalStr_(graph, resource), 100);
    }

    private static String literalStr_(ReadGraph graph, Resource resource) throws DoesNotContainValueException, ValidationException, ServiceException, BindingException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(resource, L0.Variant)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "variant");
        }
        if (graph.isInstanceOf(resource, L0.String)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "string");
        }
        if (graph.isInstanceOf(resource, L0.Integer)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "integer");
        }
        if (graph.isInstanceOf(resource, L0.Long)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "long");
        }
        if (graph.isInstanceOf(resource, L0.Boolean)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "boolean");
        }
        if (graph.isInstanceOf(resource, L0.Double)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "double");
        }
        if (graph.isInstanceOf(resource, L0.Float)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "float");
        }
        if (graph.isInstanceOf(resource, L0.Byte)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "byte");
        }
        if (graph.isInstanceOf(resource, L0.StringArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "string");
        }
        if (graph.isInstanceOf(resource, L0.IntegerArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "integer");
        }
        if (graph.isInstanceOf(resource, L0.LongArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "long");
        }
        if (graph.isInstanceOf(resource, L0.BooleanArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "boolean");
        }
        if (graph.isInstanceOf(resource, L0.DoubleArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "double");
        }
        if (graph.isInstanceOf(resource, L0.FloatArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "float");
        }
        if (graph.isInstanceOf(resource, L0.ByteArray)) {
            return DefaultStringRepresentation2.arrayStr(graph, resource, "byte");
        }
        if (graph.isInstanceOf(resource, L0.Literal)) {
            try {
                Datatype dt = (Datatype)graph.getPossibleRelatedValue(resource, L0.HasDataType, dataTypeBinding);
                if (dt != null) {
                    Binding dtb = Bindings.getBinding((Datatype)dt);
                    Object value = graph.getPossibleValue(resource, dtb);
                    if (value != null) {
                        return DataValuePrinter.writeValueSingleLine((Binding)dtb, (Object)value);
                    }
                } else {
                    return DefaultStringRepresentation2.arrayStr(graph, resource, "unknown");
                }
                return "[no value: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource, (boolean)true) + "]";
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            catch (org.simantics.databoard.binding.error.BindingException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return "[unsupported literal type: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource, (boolean)true) + "]";
    }

    private static String arrayStr(ReadGraph graph, Resource resource, String type) throws DoesNotContainValueException, ValidationException, ServiceException {
        Object value;
        if ("variant".equals(type)) {
            try {
                Databoard db = (Databoard)graph.getService(Databoard.class);
                Variant variant = (Variant)graph.getPossibleValue(resource, (Binding)db.VARIANT);
                if (variant != null) {
                    return variant.toString();
                }
            }
            catch (BindingException e) {
                return "BindingException: " + e.getMessage();
            }
        }
        if ((value = graph.getPossibleValue(resource)) == null) {
            return "no value : " + type + "[]";
        }
        Class<?> vclass = value.getClass();
        boolean isArray = vclass.isArray();
        int length = 1;
        if (isArray) {
            length = Array.getLength(value);
        }
        if (!isArray) {
            return value.toString();
        }
        if (length == 1) {
            return String.valueOf(Array.get(value, 0));
        }
        if (length > 32) {
            return type + "[" + length + "]";
        }
        StringBuilder b = new StringBuilder();
        boolean first = true;
        int i = 0;
        while (i < length) {
            if (!first) {
                b.append(',');
            }
            first = false;
            b.append(Array.get(value, i));
            ++i;
        }
        return b.toString();
    }
}

