/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.actions;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.actions.ActionContribution;
import org.simantics.browsing.ui.model.actions.CategorizedAction;
import org.simantics.browsing.ui.model.actions.IActionCategory;
import org.simantics.browsing.ui.model.actions.TestContribution;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContexts;
import org.simantics.browsing.ui.model.browsecontexts.ResolveActionBrowseContext;
import org.simantics.browsing.ui.model.nodetypes.EntityNodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ActionBrowseContext {
    NodeTypeMultiMap<ActionContribution> actionContributions = new NodeTypeMultiMap();
    THashSet<Resource> removableNodeTypes = new THashSet();
    THashSet<Resource> renameableNodeTypes = new THashSet();
    NodeTypeMultiMap<TestContribution> removalContributions = new NodeTypeMultiMap();
    NodeTypeMultiMap<TestContribution> renamingContributions = new NodeTypeMultiMap();
    private final String[] uris;

    private ActionBrowseContext(String[] uris) {
        if (uris == null) {
            throw new NullPointerException("null URIs");
        }
        this.uris = uris;
    }

    public String[] getURIs() {
        return this.uris;
    }

    public static ActionBrowseContext get(ReadGraph graph, NodeContext context, ActionBrowseContext defaultContext) throws DatabaseException {
        ActionBrowseContext mbc = (ActionBrowseContext)graph.syncRequest((Read)new ResolveActionBrowseContext(context));
        if (mbc != null) {
            return mbc;
        }
        ActionBrowseContext parentContext = (ActionBrowseContext)context.getConstant(BuiltinKeys.ACTION_BROWSE_CONTEXT);
        if (parentContext != null) {
            return parentContext;
        }
        return defaultContext;
    }

    public static ActionBrowseContext create(ReadGraph g, Collection<Resource> browseContextResources) throws DatabaseException, InvalidContribution {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        ActionBrowseContext browseContext = new ActionBrowseContext(BrowseContexts.toSortedURIs(g, browseContextResources));
        for (Resource browseContextResource : ActionBrowseContext.findSubcontexts(g, browseContextResources)) {
            for (Resource actionContributionResource : g.getObjects(browseContextResource, vr.BrowseContext_HasActionContribution)) {
                try {
                    ActionContribution.load(g, actionContributionResource, browseContext.actionContributions);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
            for (Resource canRemove : g.getObjects(browseContextResource, vr.BrowseContext_SupportsRemovalOf)) {
                browseContext.removableNodeTypes.add((Object)canRemove);
            }
            for (Resource canRemove : g.getObjects(browseContextResource, vr.BrowseContext_SupportsRenamingOf)) {
                browseContext.renameableNodeTypes.add((Object)canRemove);
            }
            for (Resource testContribution : g.getObjects(browseContextResource, vr.BrowseContext_HasTestContribution)) {
                try {
                    Set types = g.getTypes(testContribution);
                    if (types.contains(vr.RemovalTestContribution)) {
                        TestContribution.load(g, testContribution, browseContext.removalContributions);
                    }
                    if (!types.contains(vr.RenamingTestContribution)) continue;
                    TestContribution.load(g, testContribution, browseContext.renamingContributions);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        }
        return browseContext;
    }

    private static Collection<Resource> findSubcontexts(ReadGraph g, Collection<Resource> browseContexts) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance((ReadGraph)g);
        HashSet<Resource> result = new HashSet<Resource>(browseContexts);
        ArrayList<Resource> stack = new ArrayList<Resource>(browseContexts);
        while (!stack.isEmpty()) {
            Resource cur = stack.remove(stack.size() - 1);
            for (Resource sc : g.getObjects(cur, vr.BrowseContext_Includes)) {
                if (!result.add(sc)) continue;
                stack.add(sc);
            }
        }
        return result;
    }

    private static NodeType getNodeType(ReadGraph graph, NodeContext parent) throws DatabaseException {
        Object input;
        NodeType nodeType = (NodeType)parent.getConstant(NodeType.TYPE);
        if (nodeType == null && (input = parent.getConstant(BuiltinKeys.INPUT)) instanceof Resource) {
            nodeType = EntityNodeType.getNodeTypeFor(graph, (Resource)input);
        }
        return nodeType;
    }

    public Map<IActionCategory, List<Action>> getActions(ReadGraph graph, NodeContext parent, Collection<NodeContext> all) throws DatabaseException {
        NodeType nodeType = ActionBrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return Collections.emptyMap();
        }
        THashMap map = new THashMap();
        for (ActionContribution contribution : this.actionContributions.get(graph, nodeType)) {
            CategorizedAction action = contribution.getAction(graph, parent, all);
            if (action == null) continue;
            ArrayList<Action> actions = (ArrayList<Action>)map.get((Object)action.category);
            if (actions == null) {
                actions = new ArrayList<Action>();
                map.put((Object)action.category, actions);
            }
            actions.add(action.action);
        }
        return map;
    }

    public int hashCode() {
        return Arrays.hashCode(this.uris);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionBrowseContext other = (ActionBrowseContext)obj;
        return Arrays.equals(this.uris, other.uris);
    }

    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.uris);
    }

    public boolean canRemove(ReadGraph graph, NodeContext parent) throws DatabaseException {
        return this.testContributions(graph, parent, this.removalContributions, (Set<Resource>)this.removableNodeTypes);
    }

    public boolean canRename(ReadGraph graph, NodeContext parent) throws DatabaseException {
        return this.testContributions(graph, parent, this.renamingContributions, (Set<Resource>)this.renameableNodeTypes);
    }

    private boolean testContributions(ReadGraph graph, NodeContext parent, NodeTypeMultiMap<TestContribution> contributions, Set<Resource> allowedSpecialTypes) throws DatabaseException {
        NodeType nodeType = ActionBrowseContext.getNodeType(graph, parent);
        if (nodeType == null) {
            return true;
        }
        if (nodeType instanceof SpecialNodeType && allowedSpecialTypes.contains(((SpecialNodeType)nodeType).resource)) {
            return true;
        }
        for (TestContribution contribution : contributions.get(graph, nodeType)) {
            if (contribution.test(graph, parent)) continue;
            return false;
        }
        return true;
    }
}

