/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.utils.datastructures.Pair;

public class XmileUtil {
    public static final String FUNCTION_PREFIX = "XMILE.";
    public static final String TIME_PARAM = ",time";
    public static final String TIME_STEP_PARAM = ",timeStep";
    public static final String TIME_START_PARAM = ",startTime";
    public static final String TIME_STOP_PARAM = ",stopTime";
    private static final Map<String, String> keywords = new HashMap<String, String>();
    private static final List<String> time_functions;
    private static final List<String> time_step_functions;
    private static final List<String> time_start_functions;
    private static final List<String> time_stop_functions;
    public static final double SCALE_X_TO_S = 1.0;
    public static final double SCALE_S_TO_X = 1.0;

    static {
        keywords.put("TIME", "time");
        keywords.put("DT", "timeStep");
        keywords.put("STARTTIME", "startTime");
        keywords.put("STOPTIME", "stopTime");
        time_functions = new ArrayList<String>();
        time_functions.add("PULSE");
        time_functions.add("RAMP");
        time_functions.add("STEP");
        time_step_functions = new ArrayList<String>();
        time_step_functions.add("PULSE");
        time_start_functions = new ArrayList<String>();
        time_stop_functions = new ArrayList<String>();
        time_stop_functions.add("INIT");
    }

    public static String normalize(String variable) {
        String[] parts;
        if (keywords.get(variable) != null) {
            return keywords.get(variable);
        }
        StringBuilder result = new StringBuilder();
        String[] stringArray = parts = variable.split("( |_|\\\\n)+");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            Object part = stringArray[n2];
            if (result.length() > 0) {
                result.append(' ');
            }
            if (((String)part).matches("\\d.*")) {
                part = "n" + (String)part;
            }
            result.append(((String)part).substring(0, 1).toUpperCase()).append(((String)part).substring(1));
            ++n2;
        }
        return result.toString();
    }

    public static String modelicaVarToXmile(String variable) {
        if (keywords.values().contains(variable)) {
            for (String key : keywords.keySet()) {
                if (!keywords.get(key).equals(variable)) continue;
                return key;
            }
        }
        return variable.replace(' ', '_');
    }

    public static String modelicaExprToXmile(String expression) throws Exception {
        ExpressionParser parser = new ExpressionParser((Reader)new StringReader(expression));
        try {
            parser.expr();
        }
        catch (ParseException e) {
            throw new Exception("could not parse expression " + expression, e);
        }
        ArrayList<Pair> tokens = new ArrayList<Pair>();
        HashMap variables = parser.getReferences();
        for (String variable : variables.keySet()) {
            for (Token occurrence : (List)variables.get(variable)) {
                tokens.add(Pair.make((Object)occurrence, (Object)XmileUtil.modelicaVarToXmile(variable)));
            }
        }
        Collections.sort(tokens, new Comparator<Pair<Token, String>>(){

            @Override
            public int compare(Pair<Token, String> o1, Pair<Token, String> o2) {
                if (((Token)o1.first).endColumn < ((Token)o2.first).beginColumn) {
                    return -1;
                }
                return 1;
            }
        });
        StringBuilder expr = new StringBuilder();
        int last = 0;
        for (Pair token : tokens) {
            expr.append(expression.substring(last, ((Token)token.first).beginColumn - 1));
            expr.append((String)token.second);
            last = ((Token)token.first).endColumn;
        }
        expr.append(expression.substring(last));
        String result = expr.toString();
        for (String function : parser.getFunctionCallReferences().keySet()) {
            if (!function.startsWith(FUNCTION_PREFIX)) {
                throw new Exception("non-xmile function " + function + " encountered");
            }
            String replacement = function.substring(FUNCTION_PREFIX.length());
            result = result.replaceAll(function, replacement);
            if (XmileUtil.needsTime(replacement)) {
                result = result.replaceAll(TIME_PARAM, "");
            }
            if (XmileUtil.needsTimeStep(replacement)) {
                result = result.replaceAll(TIME_STEP_PARAM, "");
            }
            if (XmileUtil.needsTimeStart(replacement)) {
                result = result.replaceAll(TIME_START_PARAM, "");
            }
            if (!XmileUtil.needsTimeStop(replacement)) continue;
            result = result.replaceAll(TIME_STOP_PARAM, "");
        }
        return result;
    }

    public static String getSysdynFunction(String name) {
        return name;
    }

    public static boolean needsTime(String function) {
        return time_functions.contains(function);
    }

    public static boolean needsTimeStep(String function) {
        return time_step_functions.contains(function);
    }

    public static boolean needsTimeStart(String function) {
        return time_start_functions.contains(function);
    }

    public static boolean needsTimeStop(String function) {
        return time_stop_functions.contains(function);
    }
}

