/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import org.simantics.utils.datastructures.ArrayMapEntry;
import org.simantics.utils.datastructures.ImmutableIterator;
import org.simantics.utils.datastructures.ImmutableSet;

public class ArrayMap<K, V>
implements Map<K, V> {
    final K[] keys;
    final V[] values;
    Set<Map.Entry<K, V>> entrySet;
    Set<K> keySet;
    Collection<V> valueSet;

    public static <K2, V2> ArrayMapBuilder<K2, V2> keys(K2 ... keys) {
        return new ArrayMapBuilder(keys);
    }

    public static <K2, V2> ArrayMap<K2, V2> make(K2[] keys, V2 ... values) {
        return new ArrayMap<K2, V2>(keys, values);
    }

    public ArrayMap(K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("key array size (" + keys.length + ") != value array size (" + values.length + ")");
        }
        this.keys = keys;
        this.values = values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    public K[] getKeys() {
        return this.keys;
    }

    public K[] getKeysWithSpace(int space) {
        return Arrays.copyOf(this.keys, this.keys.length + space);
    }

    public V[] getValuesCopy() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public V[] getValuesCopyWithSpace(int space) {
        return Arrays.copyOf(this.values, this.values.length + space);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] == null) {
                    return this.values[i];
                }
                ++i;
            }
            return null;
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.keys.length) {
            K k = this.keys[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new KeySet());
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            int i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] == null) {
                    V old = this.values[i];
                    this.values[i] = value;
                    return old;
                }
                ++i;
            }
            throw new UnsupportedOperationException("key " + String.valueOf(key) + " not present in ArrayMap");
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.keys.length) {
            K k = this.keys[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                V old = this.values[i];
                this.values[i] = value;
                return old;
            }
            ++i;
        }
        throw new UnsupportedOperationException("key " + String.valueOf(key) + " not present in ArrayMap");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            if (this.containsKey(k)) continue;
            throw new UnsupportedOperationException("key " + String.valueOf(k) + " not present in ArrayMap");
        }
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public Collection<V> values() {
        return this.valueSet != null ? this.valueSet : (this.valueSet = Collections.unmodifiableCollection(Arrays.asList(this.values)));
    }

    @Override
    public int hashCode() {
        int h = 0;
        int l = this.keys.length;
        int i = 0;
        while (i < l) {
            K key = this.keys[i];
            V value = this.values[i];
            int hash = (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            h += hash;
            ++i;
        }
        return h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            int l = this.keys.length;
            int i = 0;
            while (true) {
                if (i >= l) {
                    return true;
                }
                K key = this.keys[i];
                V value = this.values[i];
                if (value == null) {
                    if (m.get(key) != null) return false;
                    if (!m.containsKey(key)) {
                        return false;
                    }
                } else if (!value.equals(m.get(key))) {
                    return false;
                }
                ++i;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        int i = 0;
        while (i < this.keys.length) {
            action.accept(this.keys[i], this.values[i]);
            ++i;
        }
    }

    public static class ArrayMapBuilder<K2, V2> {
        private final K2[] keys;

        ArrayMapBuilder(K2[] keys) {
            this.keys = keys;
        }

        public ArrayMap<K2, V2> values(V2 ... values) {
            return new ArrayMap<K2, V2>(this.keys, values);
        }
    }

    class EntrySet
    extends ImmutableSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.keys.length == 0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableIterator<Map.Entry<K, V>>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((EntrySet)EntrySet.this).ArrayMap.this.keys.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.i >= ((EntrySet)EntrySet.this).ArrayMap.this.keys.length) {
                        throw new NoSuchElementException("no more elements (" + ((EntrySet)EntrySet.this).ArrayMap.this.keys.length + " walked)");
                    }
                    ArrayMapEntry entry = new ArrayMapEntry(this.i, ((EntrySet)EntrySet.this).ArrayMap.this.keys[this.i], ((EntrySet)EntrySet.this).ArrayMap.this.values[this.i]);
                    ++this.i;
                    return entry;
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.keys.length;
        }
    }

    class KeySet
    extends ImmutableSet<K>
    implements Set<K> {
        KeySet() {
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                K[] KArray = ArrayMap.this.keys;
                int n = ArrayMap.this.keys.length;
                int n2 = 0;
                while (n2 < n) {
                    Object k = KArray[n2];
                    if (k == null) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            int hash = o.hashCode();
            K[] KArray = ArrayMap.this.keys;
            int n = ArrayMap.this.keys.length;
            int n3 = 0;
            while (n3 < n) {
                Object k = KArray[n3];
                if (o == k || hash == k.hashCode() && o.equals(k)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return ArrayMap.this.keys.length == 0;
        }

        @Override
        public Iterator<K> iterator() {
            return new ImmutableIterator<K>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((KeySet)KeySet.this).ArrayMap.this.keys.length;
                }

                @Override
                public K next() {
                    if (this.i >= ((KeySet)KeySet.this).ArrayMap.this.keys.length) {
                        throw new NoSuchElementException("no more elements (" + ((KeySet)KeySet.this).ArrayMap.this.keys.length + " walked)");
                    }
                    Object k = ((KeySet)KeySet.this).ArrayMap.this.keys[this.i];
                    ++this.i;
                    return k;
                }
            };
        }

        @Override
        public int size() {
            return ArrayMap.this.keys.length;
        }

        @Override
        public Object[] toArray() {
            return ArrayMap.this.keys;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length < ArrayMap.this.keys.length) {
                return Arrays.copyOf(ArrayMap.this.keys, ArrayMap.this.keys.length, a.getClass());
            }
            System.arraycopy(ArrayMap.this.keys, 0, a, 0, ArrayMap.this.keys.length);
            if (a.length > ArrayMap.this.keys.length) {
                a[ArrayMap.this.keys.length] = null;
            }
            return a;
        }
    }
}

