/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.omsolver;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.Resource;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.SimulationLocation;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynSensitivityAnalysisExperimentBase;
import org.simantics.sysdyn.omsolver.ModelicaSolver;
import org.simantics.sysdyn.solver.ISolverMonitor;

public class SysdynSensitivityAnalysisExperimentOMC
extends SysdynSensitivityAnalysisExperimentBase {
    private SimulationLocation simulationLocation;
    private IModelicaMonitor monitor;

    public SysdynSensitivityAnalysisExperimentOMC(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    protected void runModelica(SimulationLocation simulationLocation, IModelicaMonitor monitor, IProgressMonitor progressMonitor, HashMap<String, String> experimentParameters, HashMap<String, String> changes) throws IOException {
        this.results = null;
        this.simulationLocation = simulationLocation;
        this.monitor = monitor;
        this.progressMonitor = progressMonitor;
        if (changes == null) {
            changes = new HashMap();
        }
        String version = ModelicaManager.getOMVersion((File)simulationLocation.omHome);
        experimentParameters.put("OMC_VERSION", version);
        this.loadConfiguration();
        this.currentRun = 0;
        this.findValuesAndRun(this.parameters, changes, experimentParameters);
    }

    protected void runSensitivityRun(HashMap<String, String> values, HashMap<String, String> experimentParameters) {
        Object resFile;
        int indexOfDot = this.simulationLocation.resultFile.toString().lastIndexOf(46);
        if (indexOfDot > 1) {
            resFile = this.simulationLocation.resultFile.toString();
            String newResFile = ((String)resFile).substring(0, indexOfDot) + this.currentRun + ((String)resFile).substring(indexOfDot);
            experimentParameters.put("RESULT_FILE_NAME", newResFile);
        }
        this.progressMonitor.subTask("Simulation iteration " + (this.currentRun + 1) + "/" + this.numberOfRuns);
        try {
            this.process = ModelicaManager.runModelica((SimulationLocation)this.simulationLocation, (IModelicaMonitor)this.monitor, experimentParameters, values);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModelicaManager.printProcessOutput((Process)this.process, (IModelicaMonitor)this.monitor);
        resFile = new File(experimentParameters.get("RESULT_FILE_NAME"));
        boolean updateMonitors = this.currentRun % this.refreshRate == 0 || this.currentRun == this.numberOfRuns - 1;
        Thread resultThread = this.getResultThread((File)resFile, experimentParameters, this.monitor, this.progressMonitor, updateMonitors, this.currentRun);
        resultThread.run();
        this.process = null;
        this.progressMonitor.worked(1);
        ++this.currentRun;
    }

    public void createSolver(ISolverMonitor solverMonitor) {
        this.solver = new ModelicaSolver((SysdynExperiment)this);
    }

    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName) throws IOException {
        omcVersion = ModelicaManager.getDefaultOMVersion();
        if (omcVersion != null) {
            try {
                double v = Double.parseDouble(omcVersion.substring(0, 3));
                if (v < 1.9) {
                    monitor.message("Error: Sensitivity analysis requires OMC version >= 1.9 \nCurrent version is " + omcVersion + "\nChange version from Window->Preferences->Modelica");
                    this.simulate(false);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        super.simulate(monitor, progressMonitor, modelName);
    }
}

