/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.selectionview.SelectionInput;
import org.simantics.ui.selection.WorkbenchSelectionElement;

public final class StandardSelectionInput
implements SelectionInput {
    private final Collection<WorkbenchSelectionElement> elements;
    private final Map<String, Object> parameters;

    public StandardSelectionInput(Collection<WorkbenchSelectionElement> elements, Map<String, Object> parameters) {
        this.parameters = new HashMap<String, Object>(parameters);
        this.elements = new ArrayList<WorkbenchSelectionElement>(elements);
    }

    public StandardSelectionInput(WorkbenchSelectionElement element, Map<String, Object> parameters) {
        this.parameters = new HashMap<String, Object>(parameters);
        this.elements = Collections.singletonList(element);
    }

    public StandardSelectionInput(WorkbenchSelectionElement element) {
        this.parameters = Collections.emptyMap();
        this.elements = Collections.singletonList(element);
    }

    @Override
    public Collection<WorkbenchSelectionElement> getElements() {
        return this.elements;
    }

    @Override
    public <T> T getParameter(String key) {
        return (T)this.parameters.get(key);
    }

    public int hashCode() {
        return this.elements.hashCode() + 31 * this.parameters.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof StandardSelectionInput)) {
            return false;
        }
        StandardSelectionInput ssi = (StandardSelectionInput)object;
        if (!this.elements.equals(ssi.elements)) {
            return false;
        }
        return this.parameters.equals(ssi.parameters);
    }

    public String toString() {
        return "StandardSelectionInput[es=" + String.valueOf(this.elements) + ", par=" + String.valueOf(this.parameters) + "]";
    }
}

