/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.TabContribution;

public abstract class AbstractResourceTabContribution
implements TabContribution<Resource> {
    protected final Resource configuration;

    public AbstractResourceTabContribution(ReadGraph graph, Resource configuration) throws DatabaseException {
        this.configuration = configuration;
    }

    public abstract void getContributors(ReadGraph var1, Resource var2, Integer var3, String var4, Collection<ComparableTabContributor> var5) throws DatabaseException;

    @Override
    public boolean accept(ReadGraph graph, Object input) throws DatabaseException {
        if (!(input instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)input;
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        for (Resource r : graph.getObjects(this.configuration, SEL.AbstractResourceTabContribution_HasTest)) {
            Boolean pass = (Boolean)Functions.exec((RequestProcessor)graph, (Resource)r, (Object[])new Object[]{graph, resource});
            if (pass.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void contribute(ReadGraph graph, Resource resource, Collection<ComparableTabContributor> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
        Integer priority = (Integer)graph.getPossibleRelatedValue(this.configuration, SEL.AbstractResourceTabContribution_HasPriority, (Binding)Bindings.INTEGER);
        String label = (String)graph.getPossibleRelatedValue(this.configuration, L0.HasLabel);
        this.getContributors(graph, resource, priority, label, result);
    }
}

