/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.server.request.DocumentRequest;

public class DocumentValue
extends VariableRead<Object> {
    public DocumentValue(Variable variable) {
        super(variable);
    }

    public Object perform(ReadGraph graph) throws DatabaseException {
        if (DocumentRequest.PROFILE) {
            return this.performProfiled(graph);
        }
        return this.variable.getValue(graph);
    }

    public Object performProfiled(ReadGraph graph) throws DatabaseException {
        long start = System.nanoTime();
        Object result = this.variable.getValue(graph);
        long dura = System.nanoTime() - start;
        if ((double)dura > (double)DocumentRequest.PROFILE_THRESHOLD_VALUEREQUEST * 1000.0) {
            System.err.println("DocumentValue " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        return result;
    }

    public String toString() {
        return "DocumentValue[" + String.valueOf(this.variable) + "]";
    }
}

