/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class ElementwisePower
implements IExpression {
    public IExpression exp1;
    public IExpression exp2;

    public ElementwisePower(IExpression exp1, IExpression exp2) {
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public String toString() {
        return String.valueOf(this.exp1) + " ^ " + String.valueOf(this.exp2);
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Object left = this.exp1.evaluate(environment);
        Object right = this.exp2.evaluate(environment);
        if (left instanceof Array && right instanceof Array) {
            Array la = (Array)left;
            Array ra = (Array)right;
            return la.copy2(ra, new Array.Modifier2(){

                @Override
                public Object modify(Object o1, Object o2) {
                    if (o1 instanceof Double && o2 instanceof Double) {
                        return Math.pow((Double)o1, (Double)o2);
                    }
                    throw new IllegalStateException("Tried to pow a non-numerical array");
                }
            });
        }
        if (left instanceof Array && right instanceof Double) {
            Array la = (Array)left;
            final double rd = (Double)right;
            return la.copy(new Array.Modifier(){

                @Override
                public Object modify(Object o) {
                    if (o instanceof Double) {
                        return Math.pow((Double)o, rd);
                    }
                    throw new IllegalStateException("Tried to pow a non-numerical array");
                }
            });
        }
        if (left instanceof Double && right instanceof Array) {
            Array la = (Array)right;
            final double rd = (Double)left;
            return la.copy(new Array.Modifier(){

                @Override
                public Object modify(Object o) {
                    if (o instanceof Double) {
                        return Math.pow(rd, (Double)o);
                    }
                    throw new IllegalStateException("Tried to pow a non-numerical array");
                }
            });
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new ElementwisePower(this.exp1.withBase(frame, prefix), this.exp2.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.exp1 = this.exp1.rewrite(frame, copies);
        this.exp2 = this.exp2.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.exp1.accept(visitor);
        this.exp2.accept(visitor);
    }
}

