/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Environment;
import fi.semantum.sysdyn.solver.ExecutionException;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.Variable;

public class Assignment {
    private static final boolean VALIDATE = true;
    public IFrame model;
    public Variable target;
    public IExpression[] subscripts;
    public IExpression expression;
    public boolean isConstant = false;

    public Assignment(IFrame model, Variable target, IExpression[] subscripts, IExpression expression) {
        this.model = model;
        this.target = target;
        this.subscripts = subscripts;
        this.expression = expression;
    }

    public String toString() {
        return String.valueOf(this.target) + " = " + String.valueOf(this.expression);
    }

    public Assignment withBase(IFrame frame, String prefix) {
        if (this.subscripts != null) {
            IExpression[] subscripts2 = new IExpression[this.subscripts.length];
            int i = 0;
            while (i < this.subscripts.length) {
                subscripts2[i] = this.subscripts[i].withBase(frame, prefix);
                ++i;
            }
            return new Assignment(frame, this.target.withBase(frame, prefix), subscripts2, this.expression.withBase(frame, prefix));
        }
        return new Assignment(frame, this.target.withBase(frame, prefix), null, this.expression.withBase(frame, prefix));
    }

    public void assign(Environment env) {
        try {
            Object value = this.expression.evaluate(env);
            if (value != null) {
                this.validate(this.target, value);
                this.target.assign(env, this.subscripts, value);
                env.setAssigned(this);
            }
        }
        catch (ExecutionException e) {
            if (this.model instanceof Model) {
                throw new ExecutionException("Line " + (this.target.line - ((Model)this.model).line) + ": while evaluating " + this.target.base.name + ": " + e.getMessage());
            }
            throw new ExecutionException("While evaluating " + this.target.base.name + ": " + e.getMessage());
        }
    }

    private void validate(Variable var, Object value) {
        if (value instanceof Double) {
            if (Double.isNaN((Double)value)) {
                System.err.println("value is invalid (NaN): " + var.base.name);
                throw new IllegalStateException("value is invalid (NaN): " + var.base.name);
            }
            if (Double.isInfinite((Double)value)) {
                System.err.println("value is invalid (Infinite): " + var.base.name);
                throw new IllegalStateException("value is invalid (Infinite): " + var.base.name);
            }
        }
        if (value instanceof Array) {
            for (Object o : ((Array)value).elements()) {
                this.validate(var, o);
            }
        }
    }
}

