/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.utils;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.simantics.scenegraph.IDynamicSelectionPainterNode;
import org.simantics.scenegraph.ILookupService;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventDelegator;
import org.simantics.scenegraph.g2d.events.NodeEventHandler;
import org.simantics.scenegraph.g2d.events.SGMouseEvent;
import org.simantics.scenegraph.g2d.events.SGMouseWheelEvent;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.g2d.nodes.FlagNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.DummyComponent;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeUtil.class);
    public static final String SELECTION_NODE_NAME = "selection";
    private static final String SET_THREAD_CALLBACKS_NAME = "CGLIB$SET_THREAD_CALLBACKS";
    private static final boolean DEBUG_BOUNDS = false;

    public static INode getNearestParentOfType(INode node, Class<?> clazz) {
        ParentNode<?> parent = null;
        do {
            if ((parent = node.getParent()) != null) continue;
            return node;
        } while (!clazz.isInstance(node = parent));
        return node;
    }

    public static INode getPossibleNearestParentOfType(INode node, Class<?> clazz) {
        ParentNode<?> parent = null;
        do {
            if ((parent = node.getParent()) != null) continue;
            return null;
        } while (!clazz.isInstance(node = parent));
        return node;
    }

    public static INode getRootNode(INode node) {
        ParentNode<?> parent = null;
        while ((parent = node.getParent()) != null) {
            node = parent;
        }
        return node;
    }

    public static G2DSceneGraph getRootNode(IG2DNode node) {
        INode root = NodeUtil.getRootNode((INode)node);
        return (G2DSceneGraph)root;
    }

    public static G2DSceneGraph getPossibleRootNode(IG2DNode node) {
        INode root = NodeUtil.getRootNode((INode)node);
        return root instanceof G2DSceneGraph ? (G2DSceneGraph)root : null;
    }

    public static <T> T getNearestChildByClass(G2DParentNode parent, Class<T> clazz) {
        return NodeUtil.getNearestChildByClass(parent.getNodes(), clazz);
    }

    public static <T> T getNearestChildByClass(Collection<IG2DNode> nodes, Class<T> clazz) {
        ArrayList list = null;
        for (IG2DNode n : nodes) {
            if (clazz.isInstance(n)) {
                return (T)n;
            }
            if (!(n instanceof G2DParentNode)) continue;
            if (list == null) {
                list = new ArrayList();
            }
            list.addAll(((G2DParentNode)n).getNodes());
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        return NodeUtil.getNearestChildByClass(list, clazz);
    }

    public static INode getChildById(INode node, String id) {
        if (node instanceof ParentNode) {
            return ((ParentNode)node).getNode(id);
        }
        return null;
    }

    public static INode getFirstChild(INode node) {
        G2DParentNode pn;
        IG2DNode[] sorted;
        if (node instanceof G2DParentNode && (sorted = (pn = (G2DParentNode)node).getSortedNodes()).length > 0) {
            return sorted[0];
        }
        return null;
    }

    public static INode getPossibleChild(INode node) {
        ParentNode pn;
        if (node instanceof ParentNode && (pn = (ParentNode)node).getNodeCount() == 1) {
            return (INode)pn.getNodes().iterator().next();
        }
        return null;
    }

    public static int getDepth(INode node) {
        int result = 1;
        ParentNode<?> parent = null;
        while ((parent = node.getParent()) != null) {
            node = parent;
            ++result;
        }
        return result;
    }

    private static final void printSceneGraph(PrintStream stream, int indentLevel, INode node, String id) {
        block8: {
            block7: {
                int i = 0;
                while (i < indentLevel) {
                    stream.print("\t");
                    ++i;
                }
                stream.print(node.getSimpleClassName());
                if (id != null) {
                    String lookupId = NodeUtil.tryLookupId(node);
                    if (lookupId != null) {
                        stream.print(" {" + id + ", lookupId = " + lookupId + "}");
                    } else {
                        stream.print(" {" + id + "}");
                    }
                }
                stream.println(node);
                if (!(node instanceof G2DParentNode)) break block7;
                G2DParentNode parentNode = (G2DParentNode)node;
                String[] stringArray = parentNode.getSortedNodesById();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cid = stringArray[n2];
                    Object child = parentNode.getNode(cid);
                    if (child instanceof INode) {
                        NodeUtil.printSceneGraph(stream, indentLevel + 1, (INode)child, cid);
                    }
                    ++n2;
                }
                break block8;
            }
            if (!(node instanceof ParentNode)) break block8;
            ParentNode parentNode = (ParentNode)node;
            for (String cid : parentNode.getNodeIds()) {
                Object child = parentNode.getNode(cid);
                NodeUtil.printSceneGraph(stream, indentLevel + 1, child);
            }
        }
    }

    public static final void printSceneGraph(PrintStream stream, int indentLevel, INode node) {
        String id = null;
        ParentNode<?> parent = node.getParent();
        if (parent != null) {
            Collection<String> ids = parent.getNodeIds();
            for (String i : ids) {
                Object n = parent.getNode(i);
                if (n != node) continue;
                id = i;
                break;
            }
        }
        NodeUtil.printSceneGraph(stream, indentLevel, node, id);
    }

    public static final void printSceneGraph(int indentLevel, INode node) {
        NodeUtil.printSceneGraph(System.out, indentLevel, node);
    }

    public static final void printSceneGraph(INode node) {
        NodeUtil.printSceneGraph(System.out, 0, node);
    }

    public static final <T> List<T> forChildren(INode node, NodeProcedure<T> procedure) {
        return NodeUtil.forChildren(node, procedure, new ArrayList());
    }

    public static final <T> List<T> forChildren(INode node, NodeProcedure<T> procedure, List<T> result) {
        block5: {
            if (!(node instanceof ParentNode)) break block5;
            ParentNode pn = (ParentNode)node;
            if (node instanceof G2DParentNode) {
                G2DParentNode g2dpn = (G2DParentNode)node;
                String[] stringArray = g2dpn.getSortedNodesById();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    Object n3 = pn.getNode(id);
                    T t = procedure.execute((INode)n3, id);
                    if (t != null && result != null) {
                        result.add(t);
                    }
                    ++n2;
                }
            } else {
                for (String id : pn.getNodeIds()) {
                    Object n = pn.getNode(id);
                    T t = procedure.execute((INode)n, id);
                    if (t == null || result == null) continue;
                    result.add(t);
                }
            }
        }
        return result;
    }

    public static <T extends INode> INode forChildrenDeep(INode node, Class<T> ofClass, Function<T, INode> func) {
        return NodeUtil.forChildrenDeep(node, n -> ofClass.isInstance(n) ? (INode)func.apply(n) : null);
    }

    public static <T extends INode> INode forChildrenDeep(INode node, Function<INode, INode> func) {
        block6: {
            INode ret = func.apply(node);
            if (ret != null) {
                return ret;
            }
            if (!(node instanceof ParentNode)) break block6;
            if (node instanceof G2DParentNode) {
                G2DParentNode g2dpn = (G2DParentNode)node;
                IG2DNode[] iG2DNodeArray = g2dpn.getSortedNodes();
                int n = iG2DNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IG2DNode n3 = iG2DNodeArray[n2];
                    INode r = NodeUtil.forChildrenDeep(n3, func);
                    if (r != null) {
                        return r;
                    }
                    ++n2;
                }
            } else {
                for (INode n : ((ParentNode)node).getNodes()) {
                    INode r = NodeUtil.forChildrenDeep(n, func);
                    if (r == null) continue;
                    return r;
                }
            }
        }
        return null;
    }

    public static final int countTreeNodes(INode node) {
        int result = 1;
        if (node instanceof ParentNode) {
            ParentNode pn = (ParentNode)node;
            Collection ns = pn.getNodes();
            for (INode n : ns) {
                result += NodeUtil.countTreeNodes(n);
            }
        }
        return result;
    }

    public static final StringBuilder printTreeNodes(INode node, StringBuilder builder) {
        NodeUtil.printTreeNodes(node, 0, builder);
        return builder;
    }

    public static final StringBuilder printTreeNodes(INode node, int indent, StringBuilder builder) {
        int i = 0;
        while (i < indent) {
            builder.append(" ");
            ++i;
        }
        builder.append(node.toString() + "\n");
        if (node instanceof ParentNode) {
            ParentNode pn = (ParentNode)node;
            Collection ns = pn.getNodes();
            for (INode n : ns) {
                NodeUtil.printTreeNodes(n, indent + 2, builder);
            }
        }
        return builder;
    }

    public static final <T extends INode> Set<T> collectNodes(INode node, Class<T> clazz) {
        HashSet result = new HashSet();
        NodeUtil.collectNodes(node, clazz, result);
        return result;
    }

    public static final <T extends INode> void collectNodes(INode node, Class<T> clazz, Set<T> result) {
        if (clazz.isInstance(node)) {
            result.add(node);
        }
        if (node instanceof ParentNode) {
            ParentNode pn = (ParentNode)node;
            Collection ns = pn.getNodes();
            for (INode n : ns) {
                NodeUtil.collectNodes(n, clazz, result);
            }
        }
    }

    public static <T extends INode> T getSingleNode(INode node, Class<T> clazz) {
        Set<T> all = NodeUtil.collectNodes(node, clazz);
        if (all.size() != 1) {
            throw new RuntimeException("Expected exactly 1 instance of class " + clazz.getCanonicalName() + ", got " + all.size());
        }
        return (T)((INode)all.iterator().next());
    }

    public static final boolean hasChildren(INode node) {
        if (node instanceof ParentNode) {
            ParentNode pn = (ParentNode)node;
            return !pn.getNodes().isEmpty();
        }
        return false;
    }

    public static <T extends INode> T findNodeById(INode parent, String ... idPath) {
        INode n = parent;
        int i = 0;
        while (i < idPath.length) {
            if (!(n instanceof ParentNode)) {
                return null;
            }
            n = ((ParentNode)n).getNode(idPath[i]);
            ++i;
        }
        return (T)n;
    }

    public static boolean isSelected(INode node, int ascendLimit) {
        int steps = 0;
        ParentNode<?> pn = null;
        if (node instanceof ParentNode) {
            pn = (ParentNode<?>)node;
        } else {
            pn = node.getParent();
            ++steps;
        }
        while (pn != null && steps <= ascendLimit) {
            Object child = pn.getNode(SELECTION_NODE_NAME);
            if (child != null) {
                return true;
            }
            pn = pn.getParent();
            ++steps;
        }
        return false;
    }

    public static Container findRootPane(INode node) {
        G2DSceneGraph parent = NodeUtil.findNearestParentNode(node, G2DSceneGraph.class);
        if (parent == null) {
            return null;
        }
        return parent.getRootPane();
    }

    private static boolean isSelectionPainter(INode node) {
        if (node instanceof ISelectionPainterNode) {
            if (node instanceof IDynamicSelectionPainterNode) {
                return ((IDynamicSelectionPainterNode)((Object)node)).showsSelection();
            }
            return true;
        }
        return false;
    }

    public static boolean needSelectionPaint(INode elementNode) {
        block6: {
            block5: {
                if (NodeUtil.isSelectionPainter(elementNode)) {
                    return false;
                }
                if (!(elementNode instanceof ConnectionNode)) break block5;
                for (IG2DNode child : ((ConnectionNode)elementNode).getNodes()) {
                    if (NodeUtil.isSelectionPainter(child)) {
                        return false;
                    }
                    if (!(child instanceof SingleElementNode)) continue;
                    for (IG2DNode child2 : ((SingleElementNode)child).getNodes()) {
                        if (!NodeUtil.isSelectionPainter(child2)) continue;
                        return false;
                    }
                }
                break block6;
            }
            if (!(elementNode instanceof SingleElementNode)) break block6;
            for (INode child : ((SingleElementNode)elementNode).getNodes()) {
                if (!NodeUtil.isSelectionPainter(child)) continue;
                return false;
            }
        }
        return true;
    }

    public static Method getSetterForProperty(String property, INode node) {
        boolean isEnhanced;
        assert (node != null);
        Class<?> cl = node.getClass();
        block0: do {
            isEnhanced = false;
            Method[] methodArray = cl.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(INode.PropertySetter.class)) {
                    INode.PropertySetter ann = method.getAnnotation(INode.PropertySetter.class);
                    if (ann.value().equals(property)) {
                        return method;
                    }
                } else if (method.getName().equals(SET_THREAD_CALLBACKS_NAME) && method.getGenericParameterTypes().length == 1) {
                    isEnhanced = true;
                    cl = cl.getSuperclass();
                    continue block0;
                }
                ++n2;
            }
        } while (isEnhanced && cl != null);
        return null;
    }

    public static boolean setPropertyIfSupported(String property, Object value, INode node) {
        Method setter = NodeUtil.getSetterForProperty(property, node);
        if (setter != null) {
            Class<?>[] pc = setter.getParameterTypes();
            if (pc.length == 1 && (value == null || pc[0].isAssignableFrom(value.getClass()))) {
                try {
                    setter.invoke((Object)node, value);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.getCause().printStackTrace();
                }
            } else if (pc.length > 0) {
                LOGGER.warn("Method " + setter.getName() + " expects " + pc[0].getCanonicalName() + " (got " + value.getClass().getCanonicalName() + ").");
            }
        }
        return false;
    }

    public static INode findChildById(ParentNode<?> parent, String key) {
        Object result = parent.getNode(key);
        if (result != null) {
            return result;
        }
        for (String entry : parent.getNodeIds()) {
            if (!entry.startsWith(key)) continue;
            return parent.getNode(key);
        }
        for (INode node : parent.getNodes()) {
            if (!(node instanceof ParentNode) || (result = NodeUtil.findChildById((ParentNode)node, key)) == null) continue;
            return result;
        }
        return null;
    }

    private static int getSegmentEnd(String suffix) {
        int pos = 1;
        while (pos < suffix.length()) {
            char c = suffix.charAt(pos);
            if (c == '/' || c == '#') break;
            ++pos;
        }
        return pos;
    }

    public static String decodeString(String string) {
        return string;
    }

    public static INode browsePossible(INode node, String suffix) {
        if (suffix.isEmpty()) {
            return node;
        }
        switch (suffix.charAt(0)) {
            case '.': {
                ParentNode<?> parent = node.getParent();
                if (parent == null) {
                    return null;
                }
                return NodeUtil.browsePossible(parent, suffix.substring(1));
            }
            case '#': {
                return node;
            }
            case '/': {
                int segmentEnd = NodeUtil.getSegmentEnd(suffix);
                INode child = NodeUtil.findChildById((ParentNode)node, NodeUtil.decodeString(suffix.substring(1, segmentEnd)));
                if (child == null) {
                    return null;
                }
                return NodeUtil.browsePossible(child, suffix.substring(segmentEnd));
            }
        }
        return null;
    }

    public static Pair<INode, String> browsePossibleReference(INode node, String suffix) {
        if (suffix.isEmpty()) {
            throw new RuntimeException("Did not find a reference.");
        }
        switch (suffix.charAt(0)) {
            case '.': {
                ParentNode<?> parent = node.getParent();
                if (parent == null) {
                    return null;
                }
                return NodeUtil.browsePossibleReference(parent, suffix.substring(1));
            }
            case '#': {
                return Pair.make((Object)node, (Object)suffix.substring(1));
            }
            case '/': {
                int segmentEnd = NodeUtil.getSegmentEnd(suffix);
                INode child = NodeUtil.findChildById((ParentNode)node, NodeUtil.decodeString(suffix.substring(1, segmentEnd)));
                if (child == null) {
                    return null;
                }
                return NodeUtil.browsePossibleReference(child, suffix.substring(segmentEnd));
            }
        }
        return null;
    }

    public static INode findChildByPrefix(G2DParentNode parent, String prefix) {
        Object result = parent.getNode(prefix);
        if (result != null) {
            return result;
        }
        for (String entry : parent.getNodeIds()) {
            if (!entry.startsWith(prefix)) continue;
            return parent.getNode(entry);
        }
        for (IG2DNode node : parent.getNodes()) {
            if (!(node instanceof G2DParentNode) || (result = NodeUtil.findChildByPrefix((G2DParentNode)node, prefix)) == null) continue;
            return result;
        }
        return null;
    }

    public static Collection<String> filterDirectChildIds(ParentNode<?> parent, String prefix) {
        return NodeUtil.filterDirectChildIds(parent, new PrefixFilter(prefix));
    }

    public static Collection<String> filterDirectChildIds(ParentNode<?> parent, Filter<String> childFilter) {
        Collection<String> childIds = parent.getNodeIds();
        ArrayList<String> result = new ArrayList<String>(childIds.size());
        for (String id : childIds) {
            if (!childFilter.accept(id)) continue;
            result.add(id);
        }
        return result;
    }

    public static Collection<INode> filterDirectChildren(ParentNode<?> parent, Filter<String> childFilter) {
        Collection<String> childIds = parent.getNodeIds();
        ArrayList<INode> result = new ArrayList<INode>(childIds.size());
        for (String id : childIds) {
            if (!childFilter.accept(id)) continue;
            result.add((INode)parent.getNode(id));
        }
        return result;
    }

    public static ILookupService getLookupService(INode node) {
        ParentNode<?> root = node.getRootNode();
        if (!(root instanceof ILookupService)) {
            throw new UnsupportedOperationException("ILookupService not supported by root node " + String.valueOf(root) + " attained from " + String.valueOf(node));
        }
        return (ILookupService)((Object)root);
    }

    public static ILookupService tryGetLookupService(INode node) {
        ParentNode<?> root = node.getRootNode();
        return root instanceof ILookupService ? (ILookupService)((Object)root) : null;
    }

    public static INode lookup(INode node, String id) {
        ILookupService lookup = NodeUtil.getLookupService(node);
        return lookup.lookupNode(id);
    }

    public static INode tryLookup(INode node, String id) {
        ILookupService lookup = NodeUtil.tryGetLookupService(node);
        return lookup != null ? lookup.lookupNode(id) : null;
    }

    public static <T> T lookup(INode node, String id, Class<T> clazz) {
        ILookupService lookup = NodeUtil.getLookupService(node);
        INode found = lookup.lookupNode(id);
        return found != null ? (T)clazz.cast(found) : null;
    }

    public static <T> T tryLookup(INode node, String id, Class<T> clazz) {
        ILookupService lookup = NodeUtil.tryGetLookupService(node);
        if (lookup == null) {
            return null;
        }
        INode found = lookup.lookupNode(id);
        return found != null ? (T)clazz.cast(found) : null;
    }

    public static String lookupId(INode node) {
        ILookupService lookup = NodeUtil.getLookupService(node);
        return lookup.lookupId(node);
    }

    public static String tryLookupId(INode node) {
        ILookupService lookup = NodeUtil.tryGetLookupService(node);
        return lookup != null ? lookup.lookupId(node) : null;
    }

    public static void map(INode node, String id) {
        NodeUtil.getLookupService(node).map(id, node);
    }

    public static String unmap(INode node) {
        return NodeUtil.getLookupService(node).unmap(node);
    }

    public static String tryUnmap(INode node) {
        ILookupService lookup = NodeUtil.tryGetLookupService(node);
        return lookup != null ? lookup.unmap(node) : null;
    }

    public static EventDelegator getEventDelegator(INode node) {
        ParentNode<?> n = node.getRootNode();
        if (n instanceof G2DSceneGraph) {
            return ((G2DSceneGraph)n).getEventDelegator();
        }
        return null;
    }

    public static NodeEventHandler getNodeEventHandler(INode node) {
        ParentNode<?> n = node.getRootNode();
        return n instanceof G2DSceneGraph ? ((G2DSceneGraph)n).getEventHandler() : null;
    }

    public static AWTEvent transformEvent(AWTEvent event, IG2DNode node) {
        if (event instanceof MouseEvent) {
            AffineTransform transform = NodeUtil.getGlobalToLocalTransform(node, null);
            if (transform == null) {
                LOGGER.warn("WARNING: Non-invertible transform for node: " + String.valueOf(node));
                return event;
            }
            MouseEvent me = (MouseEvent)event;
            Point2D.Double p = new Point2D.Double(me.getX(), me.getY());
            transform.transform(p, p);
            MouseEvent e = null;
            e = event instanceof MouseWheelEvent ? new SGMouseWheelEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), ((Point2D)p).getX(), ((Point2D)p).getY(), me.getClickCount(), me.isPopupTrigger(), ((MouseWheelEvent)me).getScrollType(), ((MouseWheelEvent)me).getScrollAmount(), ((MouseWheelEvent)me).getWheelRotation(), me) : new SGMouseEvent((Component)new DummyComponent(), me.getID(), me.getWhen(), me.getModifiers(), ((Point2D)p).getX(), ((Point2D)p).getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton(), me);
            return e;
        }
        return event;
    }

    private static Rectangle2D getLocalBoundsImpl(INode node, Function1<INode, Boolean> filter, int indent) {
        if (node instanceof IG2DNode) {
            if (node instanceof G2DParentNode) {
                G2DParentNode pNode = (G2DParentNode)node;
                Iterator it = pNode.getNodes().iterator();
                if (!it.hasNext()) {
                    return null;
                }
                Rectangle2D bounds = null;
                while (it.hasNext()) {
                    Rectangle2D bl;
                    IG2DNode next = (IG2DNode)it.next();
                    if (filter != null && !((Boolean)filter.apply((Object)next)).booleanValue() || (bl = NodeUtil.getLocalBoundsImpl(next, filter, indent + 2)) == null) continue;
                    if (bounds == null) {
                        bounds = next.localToParent(bl.getFrame());
                        continue;
                    }
                    bounds.add(next.localToParent(bl));
                }
                return bounds;
            }
            Rectangle2D result = ((IG2DNode)node).getBoundsInLocal(true);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    public static Rectangle2D getLocalBounds(INode node) {
        return NodeUtil.getLocalBoundsImpl(node, null, 0);
    }

    public static Rectangle2D getLocalBounds(INode node, final Set<INode> excluding) {
        return NodeUtil.getLocalBoundsImpl(node, (Function1<INode, Boolean>)new FunctionImpl1<INode, Boolean>(){

            public Boolean apply(INode node) {
                return !excluding.contains(node);
            }
        }, 0);
    }

    public static Rectangle2D getLocalBounds(INode node, final Class<?> excluding) {
        return NodeUtil.getLocalBoundsImpl(node, (Function1<INode, Boolean>)new FunctionImpl1<INode, Boolean>(){

            public Boolean apply(INode node) {
                return !excluding.isInstance(node);
            }
        }, 0);
    }

    public static Rectangle2D getLocalBounds(INode node, final Class<?> ... excluding) {
        return NodeUtil.getLocalBoundsImpl(node, (Function1<INode, Boolean>)new FunctionImpl1<INode, Boolean>(){

            public Boolean apply(INode node) {
                Class[] classArray = excluding;
                int n = excluding.length;
                int n2 = 0;
                while (n2 < n) {
                    Class ex = classArray[n2];
                    if (ex.isInstance(node)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }, 0);
    }

    public static Rectangle2D getLocalElementBounds(INode node) {
        if (node instanceof ConnectionNode) {
            return NodeUtil.getLocalBounds(node);
        }
        if (node instanceof SingleElementNode) {
            INode image = NodeUtil.findChildByPrefix((SingleElementNode)node, "composite_image");
            if (image == null) {
                image = NodeUtil.findChildByPrefix((SingleElementNode)node, "text");
            }
            if (image == null) {
                image = NodeUtil.findChildByPrefix((SingleElementNode)node, "visual");
            }
            if (image == null) {
                image = NodeUtil.getNearestChildByClass((SingleElementNode)node, FlagNode.class);
            }
            if (image != null) {
                return NodeUtil.getLocalElementBounds(image);
            }
            return NodeUtil.getLocalBounds(node);
        }
        return NodeUtil.getLocalBounds(node);
    }

    public static <T> T findNearestParentNode(INode node, Class<T> ofClass) {
        ParentNode<?> parent = null;
        while ((parent = node.getParent()) != null) {
            if (ofClass.isInstance(parent)) {
                return ofClass.cast(parent);
            }
            node = parent;
        }
        return null;
    }

    public static void waitPending(IThreadWorkQueue thread, G2DSceneGraph sg) {
        NodeUtil.waitPending(thread, sg, 30000);
    }

    public static void waitPending(IThreadWorkQueue thread, G2DSceneGraph sg, int timeoutMs) {
        PendingTester tester = new PendingTester(sg);
        long start = System.currentTimeMillis();
        while (tester.isPending()) {
            long duration;
            thread.asyncExec((Runnable)tester);
            if (tester.isPending()) {
                tester.await();
            }
            if ((duration = System.currentTimeMillis() - start) <= (long)timeoutMs) continue;
            throw new IllegalStateException("Timeout in resolving pending nodes. " + sg.pendingReport());
        }
    }

    public static void increasePending(INode node) {
        G2DSceneGraph sg = (G2DSceneGraph)node.getRootNode();
        if (sg != null) {
            sg.increasePending(node);
        }
    }

    public static void decreasePending(INode node) {
        G2DSceneGraph sg = (G2DSceneGraph)node.getRootNode();
        if (sg != null) {
            sg.decreasePending(node);
        }
    }

    public static AffineTransform getLocalToGlobalTransform(IG2DNode node, AffineTransform result) {
        result.setToIdentity();
        ParentNode<?> parent = node.getParent();
        while (parent != null) {
            result.preConcatenate(((IG2DNode)((Object)parent)).getTransform());
            parent = parent.getParent();
        }
        return result;
    }

    public static AffineTransform getLocalToGlobalTransform(IG2DNode node) {
        return NodeUtil.getLocalToGlobalTransform(node, new AffineTransform());
    }

    public static AffineTransform getGlobalToLocalTransform(IG2DNode node) throws NoninvertibleTransformException {
        AffineTransform transform = NodeUtil.getLocalToGlobalTransform(node);
        transform.invert();
        return transform;
    }

    public static AffineTransform getGlobalToLocalTransform(IG2DNode node, AffineTransform returnIfNonInvertible) {
        AffineTransform transform = NodeUtil.getLocalToGlobalTransform(node);
        try {
            transform.invert();
            return transform;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return returnIfNonInvertible;
        }
    }

    public static Point2D worldToLocal(IG2DNode local, Point2D pt, Point2D pt2) {
        AffineTransform at = NodeUtil.getGlobalToLocalTransform(local, null);
        if (at == null) {
            pt2.setLocation(pt);
            return pt2;
        }
        return at.transform(pt, pt2);
    }

    public static Point2D localToWorld(IG2DNode local, Point2D pt, Point2D pt2) {
        AffineTransform at = NodeUtil.getLocalToGlobalTransform(local);
        return at.transform(pt, pt2);
    }

    public static String getNodeName(INode nn) {
        ParentNode<?> node;
        ParentNode<?> pn = node = nn.getParent();
        if (node instanceof G2DParentNode) {
            G2DParentNode g2dpn = (G2DParentNode)node;
            String[] stringArray = g2dpn.getSortedNodesById();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Object n3 = pn.getNode(id);
                if (nn == n3) {
                    return id;
                }
                ++n2;
            }
        }
        return null;
    }

    public static boolean isParentOf(INode parent, INode child) {
        do {
            if (parent != child) continue;
            return true;
        } while ((child = child.getParent()) != null);
        return false;
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    @FunctionalInterface
    public static interface NodeProcedure<T> {
        public T execute(INode var1, String var2);
    }

    private static class PendingTester
    implements Runnable {
        private boolean pending = true;
        private final G2DSceneGraph sg;
        private final Lock pendingLock = new ReentrantLock();
        private final Condition pendingSet = this.pendingLock.newCondition();

        public PendingTester(G2DSceneGraph sg) {
            this.sg = sg;
        }

        @Override
        public void run() {
            this.pendingLock.lock();
            try {
                this.pending = this.sg.isPending();
                this.pendingSet.signalAll();
            }
            finally {
                this.pendingLock.unlock();
            }
        }

        public boolean isPending() {
            return this.pending;
        }

        public void await() {
            this.pendingLock.lock();
            try {
                try {
                    if (this.pending) {
                        this.pendingSet.await(10L, TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.pendingLock.unlock();
                }
            }
            finally {
                this.pendingLock.unlock();
            }
        }
    }

    public static class PrefixFilter
    implements Filter<String> {
        private final String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(String t) {
            return t.startsWith(this.prefix);
        }
    }
}

