/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.ScenegraphUtils;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.IG2DNodeVisitor;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.FocusEvent;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.NodeEventHandler;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.InitValueSupport;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.utils.threads.AWTThread;

public class G2DParentNode
extends ParentNode<IG2DNode>
implements IG2DNode,
InitValueSupport,
LoaderNode {
    private static final long serialVersionUID = 4966823616578337420L;
    protected static final IG2DNode[] EMPTY_NODE_ARRAY = new IG2DNode[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private volatile transient String[] sortedChildrenIds = null;
    private volatile transient IG2DNode[] sortedChildren = null;
    protected AffineTransform transform = IdentityAffineTransform.INSTANCE;
    protected int z = 0;
    public static final Comparator<IG2DNode> G2DNODE_Z_COMPARATOR = new Comparator<IG2DNode>(){

        @Override
        public int compare(IG2DNode a, IG2DNode b) {
            int zb;
            int za = a.getZIndex();
            return za < (zb = b.getZIndex()) ? -1 : (za == zb ? 0 : 1);
        }
    };

    public void invalidateChildOrder() {
        this.sortedChildrenIds = null;
        this.sortedChildren = null;
    }

    @Override
    protected void childrenChanged() {
        this.invalidateChildOrder();
    }

    @Override
    @INode.SyncField(value={"z"})
    public void setZIndex(int z) {
        if (z != this.z) {
            G2DParentNode parent = (G2DParentNode)this.getParent();
            if (parent != null) {
                parent.invalidateChildOrder();
            }
            this.z = z;
        }
    }

    @Override
    public int getZIndex() {
        return this.z;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node.validate()) {
                node.render(g2d);
            }
            ++n2;
        }
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    @Override
    public void refresh() {
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node.validate()) {
                node.refresh();
            }
            ++n2;
        }
    }

    @Override
    public void accept(IG2DNodeVisitor visitor) {
        visitor.enter(this);
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node.validate()) {
                node.accept(visitor);
            }
            ++n2;
        }
        visitor.leave(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSortedNodesById() {
        if (this.sortedChildrenIds != null) {
            return this.sortedChildrenIds;
        }
        if (this.children.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] sorted = null;
        Map map = this.children;
        synchronized (map) {
            if (this.sortedChildrenIds != null) {
                return this.sortedChildrenIds;
            }
            sorted = this.children.keySet().toArray(EMPTY_STRING_ARRAY);
            Arrays.sort(sorted, new Comparator<String>(){

                @Override
                public int compare(String a, String b) {
                    int zb;
                    int za = ((IG2DNode)G2DParentNode.this.getNode(a)).getZIndex();
                    return za < (zb = ((IG2DNode)G2DParentNode.this.getNode(b)).getZIndex()) ? -1 : (za == zb ? 0 : 1);
                }
            });
            this.sortedChildrenIds = sorted;
        }
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IG2DNode[] getSortedNodes() {
        if (this.sortedChildren != null) {
            return this.sortedChildren;
        }
        if (this.children.isEmpty()) {
            return EMPTY_NODE_ARRAY;
        }
        IG2DNode[] sorted = null;
        Map map = this.children;
        synchronized (map) {
            if (this.sortedChildren != null) {
                return this.sortedChildren;
            }
            sorted = this.children.values().toArray(EMPTY_NODE_ARRAY);
            Arrays.sort(sorted, G2DNODE_Z_COMPARATOR);
            this.sortedChildren = sorted;
        }
        return sorted;
    }

    @Override
    public void cleanup() {
        this.rootNodeCache = DISPOSED;
        this.sortedChildren = null;
        this.sortedChildrenIds = null;
        this.transform = IdentityAffineTransform.INSTANCE;
        super.cleanup();
    }

    @Override
    public void repaint() {
        ParentNode<?> parent = this.getParent();
        while (parent != null && !(parent instanceof G2DSceneGraph)) {
            parent = parent.getParent();
        }
        if (parent == null || ((G2DSceneGraph)parent).getRootPane() == null) {
            return;
        }
        ((G2DSceneGraph)parent).getRootPane().repaint();
    }

    @Override
    public void asyncRemoveNode(INode node) {
        ParentNode<?> parent = this.getParent();
        while (parent != null && parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (parent != null) {
            parent.asyncRemoveNode(node);
        }
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    @INode.PropertySetter(value="Transform")
    @INode.SyncField(value={"transform"})
    public void setTransform(AffineTransform transform) {
        assert (transform != null);
        this.transform = transform.isIdentity() ? IdentityAffineTransform.INSTANCE : transform;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D local = this.getBoundsInLocal();
        if (local == null) {
            return null;
        }
        if (this.transform.isIdentity()) {
            return local;
        }
        return this.transform.createTransformedShape(local).getBounds2D();
    }

    @Override
    public boolean contains(Point2D point) {
        Rectangle2D bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        return bounds.contains(point);
    }

    @Override
    public boolean intersects(Rectangle2D b) {
        if (b == null) {
            return true;
        }
        Rectangle2D a = this.getBounds();
        if (a == null) {
            return true;
        }
        double ax = a.getX();
        double ay = a.getY();
        double aw = a.getWidth();
        double ah = a.getHeight();
        double bx = b.getX();
        double by = b.getY();
        double bw = b.getWidth();
        double bh = b.getHeight();
        return ax + aw >= bx && ay + ah >= by && ax <= bx + bw && ay <= by + bh;
    }

    @Override
    public Point2D localToParent(Point2D point) {
        return this.transform.transform(point, null);
    }

    @Override
    public Rectangle2D localToParent(Rectangle2D rect) {
        return this.transform.createTransformedShape(rect).getBounds2D();
    }

    @Override
    public Point2D parentToLocal(Point2D point) {
        AffineTransform inverse = null;
        try {
            inverse = this.transform.createInverse();
            return inverse.transform(point, null);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return point;
        }
    }

    @Override
    public Rectangle2D parentToLocal(Rectangle2D rect) {
        AffineTransform inverse = null;
        try {
            inverse = this.transform.createInverse();
            return inverse.createTransformedShape(rect).getBounds2D();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
            return rect;
        }
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.getBoundsInLocal(false);
    }

    @Override
    public Rectangle2D getBoundsInLocal(boolean ignoreNulls) {
        Iterator it = this.getNodes().iterator();
        if (!it.hasNext()) {
            return null;
        }
        Rectangle2D bounds = null;
        while (it.hasNext()) {
            IG2DNode node = (IG2DNode)it.next();
            Rectangle2D b = node.getBoundsInLocal(ignoreNulls);
            if (b == null && !ignoreNulls) {
                return null;
            }
            if (b == null || GeometryUtils.isUndefinedRectangle(b)) continue;
            b = node.localToParent(b);
            if (bounds == null) {
                bounds = b.getFrame();
                continue;
            }
            bounds.add(b);
        }
        return bounds;
    }

    @Override
    public Point2D localToControl(Point2D point) {
        G2DParentNode node = this;
        while (node != null) {
            node.getTransform().transform(point, null);
            node = (G2DParentNode)node.getParent();
        }
        return point;
    }

    @Override
    public Rectangle2D localToControl(Rectangle2D rect) {
        Shape shape = rect;
        G2DParentNode node = this;
        while (node != null) {
            shape = node.getTransform().createTransformedShape(shape);
            node = (G2DParentNode)node.getParent();
        }
        return shape.getBounds2D();
    }

    @Override
    public Point2D controlToLocal(Point2D point) {
        AffineTransform at = NodeUtil.getGlobalToLocalTransform(this, null);
        if (at == null) {
            return point;
        }
        return at.transform(point, null);
    }

    @Override
    public Rectangle2D controlToLocal(Rectangle2D rect) {
        AffineTransform at = NodeUtil.getGlobalToLocalTransform(this, null);
        if (at == null) {
            return rect;
        }
        return GeometryUtils.transformRectangle(at, rect);
    }

    public IG2DNode pickNode(Point2D point) {
        Point2D localpoint = this.parentToLocal(point);
        IG2DNode[] nodes = this.getSortedNodes();
        int i = nodes.length - 1;
        while (i >= 0) {
            IG2DNode n = nodes[i];
            if (n instanceof G2DParentNode) {
                IG2DNode node = ((G2DParentNode)n).pickNode(localpoint);
                if (node != null) {
                    return node;
                }
            } else if (n.contains(localpoint)) {
                return n;
            }
            --i;
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " [z=" + this.z + ", transform=" + String.valueOf(this.transform) + "]";
    }

    @Override
    public void initValues() {
        IG2DNode[] iG2DNodeArray = this.getSortedNodes();
        int n = iG2DNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IG2DNode node = iG2DNodeArray[n2];
            if (node instanceof InitValueSupport) {
                ((InitValueSupport)((Object)node)).initValues();
            }
            ++n2;
        }
    }

    @Override
    public G2DSceneGraph getRootNode2D() {
        ParentNode<?> root = this.getRootNode();
        return (G2DSceneGraph)root;
    }

    @Override
    public boolean hasFocus() {
        return this.getFocusNode() == this;
    }

    @Override
    public IG2DNode getFocusNode() {
        return this.getRootNode2D().getFocusNode();
    }

    @Override
    public void setFocusNode(IG2DNode node) {
        this.getRootNode2D().setFocusNode(node);
    }

    protected NodeEventHandler getEventHandler() {
        return NodeUtil.getNodeEventHandler(this);
    }

    protected void addEventHandler(IEventHandler handler) {
        this.getEventHandler().add(handler);
    }

    protected void removeEventHandler(IEventHandler handler) {
        this.getEventHandler().remove(handler);
    }

    @Override
    public int getEventMask() {
        return 0;
    }

    @Override
    public boolean handleEvent(Event e) {
        int eventType = EventTypes.toType(e);
        switch (eventType) {
            case 1: {
                return this.handleCommand((CommandEvent)e);
            }
            case 2: 
            case 3: {
                return this.handleFocusEvent((FocusEvent)e);
            }
            case 4: {
                return this.keyPressed((KeyEvent.KeyPressedEvent)e);
            }
            case 5: {
                return this.keyReleased((KeyEvent.KeyReleasedEvent)e);
            }
            case 6: {
                return this.mouseButtonPressed((MouseEvent.MouseButtonPressedEvent)e);
            }
            case 7: {
                return this.mouseButtonReleased((MouseEvent.MouseButtonReleasedEvent)e);
            }
            case 8: {
                return this.mouseClicked((MouseEvent.MouseClickEvent)e);
            }
            case 9: {
                return this.mouseDoubleClicked((MouseEvent.MouseDoubleClickedEvent)e);
            }
            case 13: {
                return this.mouseMoved((MouseEvent.MouseMovedEvent)e);
            }
            case 10: {
                return this.mouseDragged((MouseEvent.MouseDragBegin)e);
            }
            case 11: {
                return this.mouseEntered((MouseEvent.MouseEnterEvent)e);
            }
            case 12: {
                return this.mouseExited((MouseEvent.MouseExitEvent)e);
            }
            case 14: {
                return this.mouseWheelMoved((MouseEvent.MouseWheelMovedEvent)e);
            }
            case 15: {
                return this.handleTimeEvent((TimeEvent)e);
            }
        }
        return false;
    }

    protected boolean keyReleased(KeyEvent.KeyReleasedEvent e) {
        return false;
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent e) {
        return false;
    }

    protected boolean handleCommand(CommandEvent e) {
        return false;
    }

    protected boolean handleFocusEvent(FocusEvent e) {
        return false;
    }

    protected boolean handleKeyEvent(KeyEvent e) {
        return false;
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        return false;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        return false;
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent e) {
        return false;
    }

    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent e) {
        return false;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        return false;
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        return false;
    }

    protected boolean mouseEntered(MouseEvent.MouseEnterEvent e) {
        return false;
    }

    protected boolean mouseExited(MouseEvent.MouseExitEvent e) {
        return false;
    }

    protected boolean mouseWheelMoved(MouseEvent.MouseWheelMovedEvent e) {
        return false;
    }

    protected boolean handleTimeEvent(TimeEvent e) {
        return false;
    }

    protected void setCursor(int cursorType) {
        Container rootPane = NodeUtil.findRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(cursorType));
        }
    }

    protected void setCursor(Cursor cursor) {
        Container rootPane = NodeUtil.findRootPane(this);
        if (rootPane != null) {
            rootPane.setCursor(cursor);
        }
    }

    @Override
    public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
        return ScenegraphUtils.getMethodPropertyFunction(AWTThread.getThreadAccess(), this, propertyName);
    }

    @Override
    public <T> T getProperty(String propertyName) {
        return null;
    }

    @Override
    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
    }

    public void synchronizeTransform(double[] data) {
        this.setTransform(new AffineTransform(data));
    }
}

