/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.imports;

import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.Simantics;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.ui.dialogs.ShowError;

public class ModuleSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SCL_MODULE_SELECTION_DIALOG = "SCL_MODULE_SELECTION_DIALOG";
    Read<Collection<String>> query;
    Comparator<String> comparator = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };

    public ModuleSelectionDialog(Shell shell, Read<Collection<String>> query) {
        super(shell, true);
        this.query = query;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(SCL_MODULE_SELECTION_DIALOG);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(SCL_MODULE_SELECTION_DIALOG);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){
            {
                String patternText = this.getPattern();
                this.patternMatcher = new SearchPattern();
                if (patternText != null && patternText.length() > 0) {
                    this.patternMatcher.setPattern(patternText);
                } else {
                    this.patternMatcher.setPattern("*");
                }
            }

            public boolean matchItem(Object item) {
                if (this.getPattern().indexOf(47) > 0) {
                    return this.matches((String)item);
                }
                String[] stringArray = ((String)item).split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    if (this.matches(part)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator getItemsComparator() {
        return this.comparator;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        try {
            for (String module : (Collection)Simantics.getSession().syncRequest(this.query, (Listener)TransientCacheListener.instance())) {
                contentProvider.add((Object)module, itemsFilter);
            }
        }
        catch (DatabaseException e) {
            ShowError.showError((String)"Failed to find modules", (String)"Exception was thrown during search for modules", (Throwable)e);
            this.close();
        }
        if (progressMonitor != null) {
            progressMonitor.done();
        }
    }

    public String getElementName(Object item) {
        return (String)item;
    }
}

