/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.features;

import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.IProject;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.IEditorNamingService;
import org.simantics.ui.workbench.IResourceEditorInput;

public class EditorNamingService
implements IEditorNamingService {
    public String getName(ReadGraph g, String editorId, IEditorInput in) throws DatabaseException {
        return this.truncated(this.getNameImpl(g, editorId, in), 256);
    }

    protected String getNameImpl(ReadGraph g, String editorId, IEditorInput in) throws DatabaseException {
        Resource defines;
        Resource componentType;
        if (!(in instanceof IResourceEditorInput)) {
            return "Unsupported input: " + String.valueOf(in);
        }
        IResourceEditorInput input = (IResourceEditorInput)in;
        ResourceArray a = input.getResourceArray();
        if (a.isEmpty()) {
            return "(empty input)";
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
        if (a.resources.length > 1) {
            StringBuilder sb = new StringBuilder();
            Resource component = a.resources[1];
            sb.append((String)g.adapt(component, String.class));
            sb.append(" (");
            Resource last = a.resources[a.resources.length - 1];
            String partOfModel = null;
            Resource topmostComposite = g.getPossibleObject(last, l0.PartOf);
            if (topmostComposite != null && (partOfModel = this.getModelName(g, topmostComposite)) != null) {
                sb.append(partOfModel);
            }
            if (a.resources.length > 2) {
                int i = a.resources.length - 1;
                while (i >= 2) {
                    sb.append('.');
                    String pathElementName = (String)g.adapt(a.resources[i], String.class);
                    sb.append(pathElementName);
                    --i;
                }
            }
            sb.append(')');
            return sb.toString();
        }
        Resource mainInput = a.resources[0];
        Resource composite = null;
        if (g.isInstanceOf(mainInput, dr.Diagram)) {
            String name;
            composite = g.getPossibleObject(mainInput, mr.DiagramToComposite);
            if (composite == null) {
                Resource symbol = (Resource)g.sync((ReadInterface)new PossibleObjectWithType(mainInput, sr.Defines, dr.ElementClass));
                if (symbol != null) {
                    Resource type = g.getSingleObject(symbol, l0.PartOf);
                    return (String)g.adapt(type, String.class) + " (Symbol)";
                }
                return (String)g.adapt(input.getResource(), String.class);
            }
            String modelName = this.getModelName(g, composite);
            if (modelName != null) {
                return modelName;
            }
            componentType = g.getPossibleObject(composite, sr.Defines);
            if (componentType != null && g.isInstanceOf(componentType, sr.ComponentType)) {
                return (String)g.adapt(this.getPossibleSingletonInstance(g, componentType), String.class);
            }
            if (composite != null && (name = (String)g.getPossibleAdapter(composite, String.class)) != null) {
                return name;
            }
        }
        if (g.isInstanceOf(mainInput, dr.Composite) && (defines = g.getPossibleObject(mainInput, sr.Defines)) != null && g.isInheritedFrom(defines, dr.DefinedElement) && (componentType = g.getPossibleObject(defines, mr.SymbolToComponentType)) != null) {
            return (String)g.adapt(this.getPossibleSingletonInstance(g, componentType), String.class) + " (Symbol)";
        }
        String name = (String)g.getPossibleAdapter(input.getResource(), String.class);
        if (name == null) {
            name = "(no name)";
        }
        return name;
    }

    protected Resource getPossibleSingletonInstance(ReadGraph g, Resource componentType) throws DatabaseException {
        Resource instance = null;
        return instance != null ? instance : componentType;
    }

    protected String getModelName(ReadGraph g, Resource configurationComposite) throws DatabaseException {
        Resource model = g.getPossibleObject(configurationComposite, SimulationResource.getInstance((ReadGraph)g).IsConfigurationOf);
        return model != null ? (String)g.adapt(model, String.class) : null;
    }

    protected String truncated(String name, int maxLength) throws DatabaseException {
        if (name.length() <= maxLength) {
            return name;
        }
        return name.substring(0, Math.max(0, maxLength - 3)) + "...";
    }

    public static EditorNamingService install(IProject project) {
        EditorNamingService service = new EditorNamingService();
        project.setHint(IEditorNamingService.KEY_EDITOR_NAMING_SERVICE, (Object)service);
        return service;
    }
}

