/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.simantics.NameLabelMode;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.componentTypeEditor.Messages;
import org.simantics.modeling.ui.features.EditorNamingService2;
import org.simantics.ui.workbench.IEditorNamingService2;
import org.simantics.ui.workbench.IResourceEditorInput;

public class ProceduralComponentTypeEditorNamingService
extends EditorNamingService2
implements IEditorNamingService2 {
    @Override
    public String getName(ReadGraph graph, String editorId, IEditorInput input) throws DatabaseException {
        Resource code;
        if (input instanceof IResourceEditorInput && (code = ((IResourceEditorInput)input).getResource()) != null) {
            return this.truncated(this.getPropertyOwnerName(graph, code) + " (Code)", 256);
        }
        return NLS.bind((String)Messages.ProceduralComponentTypeEditorNamingService_UnsupportedInput, (Object)input);
    }

    public String getToolTipText(ReadGraph graph, String editorId, IEditorInput input) throws DatabaseException {
        Resource code;
        if (input instanceof IResourceEditorInput && (code = ((IResourceEditorInput)input).getResource()) != null) {
            StringBuilder sb = new StringBuilder();
            this.getTooltip(graph, editorId, (IResourceEditorInput)input, sb);
            return sb.toString();
        }
        return NLS.bind((String)Messages.ProceduralComponentTypeEditorNamingService_UnsupportedInput, (Object)input);
    }

    private StringBuilder getTooltip(ReadGraph graph, String editorId, IResourceEditorInput input, StringBuilder sb) throws DatabaseException {
        Resource root;
        Resource r = input.getResource();
        NameLabelMode mode = NameLabelUtil.getNameLabelMode((RequestProcessor)graph);
        String name = this.getName(graph, editorId, (IEditorInput)input);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource owner = graph.getPossibleObject(r, L0.PropertyOf);
        if (owner != null && (root = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(owner))) != null) {
            ResourceArray path = ProceduralComponentTypeEditorNamingService.getPathInIndexRoot(graph, owner);
            int i = path.size() - 2;
            while (i > 0) {
                Object segment = NameLabelUtil.modalName((ReadGraph)graph, (Resource)path.get(i), (NameLabelMode)mode);
                if (((String)segment).contains("/")) {
                    segment = "\"" + (String)segment + "\"";
                }
                sb.append((String)segment).append("/");
                --i;
            }
            sb.append(name);
            String rootLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)root, (NameLabelMode)mode);
            sb.append(" (" + rootLabel + ")");
            return sb;
        }
        sb.append(name);
        return sb;
    }

    private String getPropertyOwnerName(ReadGraph graph, Resource property) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource owner = graph.getPossibleObject(property, L0.PropertyOf);
        if (owner == null) {
            return "No owner (Code)";
        }
        return (String)graph.getPossibleRelatedValue(owner, L0.HasName);
    }

    private static ResourceArray getPathInIndexRoot(ReadGraph graph, Resource r) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ArrayList<Resource> path = new ArrayList<Resource>();
        while (true) {
            path.add(r);
            if (graph.isInstanceOf(r, L0.IndexRoot)) {
                return new ResourceArray(path);
            }
            Resource partOf = graph.getPossibleObject(r, L0.PartOf);
            if (partOf == null) {
                return ResourceArray.EMPTY;
            }
            r = partOf;
        }
    }
}

