/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardCopyHandler;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardCutHandler;
import org.simantics.modeling.ui.modelBrowser.handlers.StandardPasteHandler;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ISelectionUtils;

public class SCLClipboard {
    public static void copyNode(Resource node) {
        ISelection selection = ISelectionUtils.createSelection((Object[])new Object[]{node});
        Resource[] rs = new Resource[]{node};
        StandardCopyHandler.copyResourcesToClipboard(rs, selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void copyNodes(List<Resource> nodes) {
        ISelection selection = ISelectionUtils.createSelection((Object[])new Object[]{nodes});
        Resource[] rs = nodes.toArray(new Resource[0]);
        StandardCopyHandler.copyResourcesToClipboard(rs, selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void cutNode(Resource node) {
        ISelection selection = ISelectionUtils.createSelection((Object[])new Object[]{node});
        Resource[] rs = new Resource[]{node};
        StandardCutHandler.cutResourcesToClipboard(rs, selection);
    }

    public static void cutNodes(List<Resource> nodes) {
        ISelection selection = ISelectionUtils.createSelection((Object[])new Object[]{nodes});
        Resource[] rs = nodes.toArray(new Resource[0]);
        StandardCutHandler.cutResourcesToClipboard(rs, selection);
    }

    public static void pasteNode(Resource target) {
        PasteHandler handler = StandardPasteHandler.getPasteHandlerFromResource(target, PasteHandler.class);
        StandardPasteHandler.pasteResourceFromClipboardWithoutMonitor(handler);
    }

    public static void copyPasteNode(Resource node, Resource target) {
        SCLClipboard.copyNode(node);
        SCLClipboard.pasteNode(target);
    }

    public static boolean copyPasteDiagramContents(final ICanvasContext source_ctx, final ICanvasContext target_ctx, List<Resource> modules) throws DatabaseException {
        IDiagram idiagram = (IDiagram)source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        DataElementMap dem = (DataElementMap)idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (dem != null) {
            final ArrayList<IElement> newSelection = new ArrayList<IElement>();
            for (Resource module : modules) {
                IElement element = dem.getElement(idiagram, (Object)module);
                if (element != null) {
                    newSelection.add(element);
                    continue;
                }
                throw new DatabaseException("Could not find IElement for " + String.valueOf(element));
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (source_ctx.isDisposed()) {
                        return;
                    }
                    Selection selection = (Selection)source_ctx.getAtMostOneItemOfClass(Selection.class);
                    if (selection != null) {
                        selection.setSelection(0, newSelection);
                    }
                    CanvasUtils.sendCommand((ICanvasContext)source_ctx, (Command)Commands.COPY);
                    CanvasUtils.sendCommand((ICanvasContext)target_ctx, (Command)Commands.PASTE);
                }
            });
            while (source_ctx.getEventQueue().size() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return true;
    }

    public static boolean delete(final ICanvasContext source_ctx, List<Resource> modules) throws DatabaseException {
        IDiagram idiagram = (IDiagram)source_ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
        DataElementMap dem = (DataElementMap)idiagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
        if (dem != null) {
            final ArrayList<IElement> newSelection = new ArrayList<IElement>();
            for (Resource module : modules) {
                IElement element = dem.getElement(idiagram, (Object)module);
                if (element != null) {
                    newSelection.add(element);
                    continue;
                }
                throw new DatabaseException("Could not find IElement for " + String.valueOf(element));
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (source_ctx.isDisposed()) {
                        return;
                    }
                    Selection selection = (Selection)source_ctx.getAtMostOneItemOfClass(Selection.class);
                    if (selection != null) {
                        selection.setSelection(0, newSelection);
                    }
                    CanvasUtils.sendCommand((ICanvasContext)source_ctx, (Command)Commands.DELETE);
                }
            });
            while (source_ctx.getEventQueue().size() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            ThreadUtils.syncExec((IThreadWorkQueue)source_ctx.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        return true;
    }
}

