/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.ext;

import gnu.trove.ext.DualIdContainer;
import gnu.trove.ext.HashBase;

public class DualIdContainerHashMap<T extends DualIdContainer>
extends HashBase<T> {
    public DualIdContainerHashMap(Class<T> clazz) throws Exception {
        super(clazz, (DualIdContainer)clazz.getDeclaredConstructor(Integer.TYPE, Integer.TYPE).newInstance(-1, -1));
    }

    private final int insertionIndex(long id) {
        DualIdContainer[] set = (DualIdContainer[])this._set;
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainer cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.longId()) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.longId());
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.longId())) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    private final int removalIndex(long id) {
        DualIdContainer[] set = (DualIdContainer[])this._set;
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainer cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || id != cur.longId()) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.longId()));
        }
        return cur == null ? -1 : index;
    }

    public T remove(long id) {
        DualIdContainer prev = null;
        int index = this.removalIndex(id);
        if (index >= 0) {
            prev = ((DualIdContainer[])this._set)[index];
            this.removeAt(index);
        }
        return (T)prev;
    }

    public final T put(long id, T value) {
        DualIdContainer previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = ((DualIdContainer[])this._set)[index];
            isNewMapping = false;
            throw new Error("Duplicate entry: " + String.valueOf(value));
        }
        DualIdContainer oldValue = ((DualIdContainer[])this._set)[index];
        ((DualIdContainer[])this._set)[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldValue == null);
        }
        return (T)previous;
    }

    public final T get(long id) {
        DualIdContainer[] set = (DualIdContainer[])this._set;
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainer cur = set[index];
        if (cur == null) {
            return null;
        }
        if (cur == this.REMOVED || id != cur.longId()) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.longId()));
        }
        return (T)cur;
    }

    private final int rehashInsertionIndex(long id, T[] set) {
        int hash = 31 * (int)(id >>> 32) + (int)id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        T cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.longId()) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.longId());
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.longId())) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected final void rehash(int newCapacity) {
        int oldCapacity = ((DualIdContainer[])this._set).length;
        DualIdContainer[] oldSet = (DualIdContainer[])this._set;
        DualIdContainer[] newSet = (DualIdContainer[])this.createArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == this.REMOVED) continue;
            DualIdContainer o = oldSet[i];
            int index = this.rehashInsertionIndex(o.longId(), newSet);
            if (index < 0) {
                this.throwObjectContractViolation(newSet[-index - 1], o);
            }
            newSet[index] = o;
        }
        this._set = newSet;
    }
}

