/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.common.matrix;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.spreadsheet.Matrix;

public class MatrixImpl
implements Matrix,
Externalizable {
    private int rows;
    private int columns;
    private Object[] data;

    public MatrixImpl() {
    }

    public MatrixImpl(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.data = new Object[rows * columns];
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getRowCount() {
        return this.rows;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.data = new Object[this.rows * this.columns];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = in.readObject();
            ++i;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.columns);
        Object[] objectArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            out.writeObject(o);
            ++n2;
        }
    }

    public Object get(int row, int column) {
        return this.data[column * this.rows + row];
    }

    public void setColumn(int column, Collection<Object> objects) {
        int index = this.rows * column;
        for (Object o : objects) {
            this.data[index++] = o;
        }
    }

    public void set(int row, int column, Object object) {
        this.data[this.rows * column + row] = object;
    }

    public Collection<Object> getColumn(int column) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.rows) {
            result.add(this.data[this.rows * column + i]);
            ++i;
        }
        return result;
    }

    public Collection<Object> getRow(int row) {
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < this.columns) {
            result.add(this.data[row + this.columns * i]);
            ++i;
        }
        return result;
    }
}

