/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.db.Issue;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.ResourceRead3;
import org.simantics.db.common.utils.Functions;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.issues.common.ManagedIssues;
import org.simantics.issues.common.StandardIssueDescription;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyIssueValidator2
extends ResourceRead3<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyIssueValidator2.class);
    public static final boolean DEBUG = false;

    public DependencyIssueValidator2(Resource resource, Resource model, Resource source) {
        super(resource, model, source);
    }

    public Boolean perform(ReadGraph graph) throws DatabaseException {
        Set existing = (Set)graph.syncRequest((Read)new DependencyIssueDescriptions(this.resource3, this.resource), (Listener)TransientCacheListener.instance());
        if (!graph.hasStatement(this.resource)) {
            return existing.isEmpty();
        }
        Set contexts = (Set)graph.syncRequest((Read)new Contexts(this.resource3, this.resource), (Listener)TransientCacheListener.instance());
        return existing.equals(contexts);
    }

    static class Contexts
    extends ResourceRead2<Set<Issue>> {
        public Contexts(Resource source, Resource resource) {
            super(source, resource);
        }

        public Set<Issue> perform(ReadGraph graph) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            IssueResource IR = IssueResource.getInstance((ReadGraph)graph);
            Resource constraint = graph.getSingleObject(this.resource, IR.Sources_DependencyTracker_HasConstraint);
            Resource function = graph.getSingleObject(constraint, L0.Constraint_Validator);
            try {
                HashSet<Issue> contexts = new HashSet<Issue>((List)Functions.exec((RequestProcessor)graph, (Resource)function, (Object[])new Object[]{graph, this.resource2}));
                return contexts;
            }
            catch (DatabaseException e) {
                LOGGER.error("Reading a constraint validator failed", (Throwable)e);
                return Collections.emptySet();
            }
        }

        public String toString() {
            return "DependencyIssueValidators2$Contexts[resource=" + String.valueOf(this.resource2) + " source=" + String.valueOf(this.resource) + "]";
        }
    }

    static class DependencyIssueDescriptions
    extends ResourceRead2<Set<Issue>> {
        public DependencyIssueDescriptions(Resource source, Resource context0) {
            super(source, context0);
        }

        public Set<Issue> perform(ReadGraph graph) throws DatabaseException {
            HashSet<Issue> result = new HashSet<Issue>();
            for (Resource issue : (Collection)graph.syncRequest((Read)new ManagedIssues(this.resource))) {
                Issue desc = (Issue)graph.sync((ReadInterface)new StandardIssueDescription(issue));
                if (desc == null || !this.resource2.equals(desc.getMainContext())) continue;
                result.add(desc);
            }
            return result;
        }
    }
}

