/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;

public class MoveRouteGraphConnection
extends ModificationAdapter {
    Resource connection;
    double offsetx;
    double offsety;

    public MoveRouteGraphConnection(Resource connection, double offsetx, double offsety) {
        this(LOW_PRIORITY, connection, offsetx, offsety);
    }

    public MoveRouteGraphConnection(Double priority, Resource connection, double offsetx, double offsety) {
        super(priority);
        this.connection = connection;
        this.offsetx = offsetx;
        this.offsety = offsety;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource node : graph.getObjects(this.connection, DIA.HasInteriorRouteNode)) {
            if (!graph.isInstanceOf(node, DIA.RouteLine)) continue;
            Boolean isHorizontal = (Boolean)graph.getRelatedValue(node, DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
            Double pos = (Double)graph.getRelatedValue(node, DIA.HasPosition, (Binding)Bindings.DOUBLE);
            pos = Boolean.TRUE.equals(isHorizontal) ? Double.valueOf(pos + this.offsety) : Double.valueOf(pos + this.offsetx);
            graph.claimLiteral(node, DIA.HasPosition, (Object)pos);
        }
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Transformed " + String.valueOf(this.connection)));
    }
}

