/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.diagram.profile.IconButtonConfiguration;
import org.simantics.diagram.profile.IconButtonNode;
import org.simantics.diagram.profile.IconButtonResult;
import org.simantics.diagram.profile.IconButtonState;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;

public abstract class IconButtonStyleBase<T extends IconButtonResult>
extends StyleBase<T> {
    protected abstract String getNodePrefix();

    protected abstract Class<?> getNodeClass();

    public IconButtonStyleBase(Object identity) {
        super(identity);
    }

    public IconButtonStyleBase() {
    }

    private AffineTransform translateAndScaleIfNeeded(AffineTransform tr, Vec2d offset, boolean relativeTransform) {
        if (relativeTransform) {
            if (!offset.isZero()) {
                tr = new AffineTransform(tr);
                tr.translate(offset.x, offset.y);
            }
        } else {
            Vec2d translation = new Vec2d(tr.getTranslateX() + offset.x, tr.getTranslateY() + offset.y);
            tr = new AffineTransform();
            tr.translate(translation.x, translation.y);
        }
        return tr;
    }

    private AffineTransform getSymbolTransform(INode node, Vec2d offset, boolean relativeTransform) {
        if (node instanceof SingleElementNode) {
            SingleElementNode s = (SingleElementNode)node;
            INode symbol = NodeUtil.findChildByPrefix((G2DParentNode)s, (String)"composite_image");
            return this.translateAndScaleIfNeeded(symbol != null ? ((IG2DNode)symbol).getTransform() : new AffineTransform(), offset, relativeTransform);
        }
        return null;
    }

    @Override
    public void applyStyleForNode(EvaluationContext observer, INode node, T result) {
        if (result == null) {
            ProfileVariables.denyChildren((INode)node, (String)this.getNodePrefix());
            return;
        }
        IconButtonState state = result.getState();
        IconButtonConfiguration config = state.getConfiguration();
        if (config.getOffset() == null) {
            ProfileVariables.denyChild((INode)node, (String)(this.getNodePrefix() + config.getId()));
            return;
        }
        IconButtonNode iconNode = (IconButtonNode)ProfileVariables.claimChild((INode)node, (String)"", (String)(this.getNodePrefix() + config.getId()), this.getNodeClass(), (Observer)observer);
        iconNode.setZIndex(Integer.MAX_VALUE);
        iconNode.setTransform(this.getSymbolTransform(node, config.getOffset(), config.getRelativeTransform()));
        iconNode.setData((IconButtonResult)result);
    }

    @Override
    protected void cleanupStyleForNode(EvaluationContext observer, INode node) {
        ProfileVariables.denyChildren((INode)node, (String)this.getNodePrefix());
    }
}

