/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.widgets.Display;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.exception.CannotRemoveException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.diagram.commandlog.DeleteElementCommand;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.synchronization.graph.RemoveBranchpoint;
import org.simantics.diagram.synchronization.graph.RemoveElement;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Relationship;
import org.simantics.g2d.diagram.handler.RelationshipHandler;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.BendsHandler;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.utils.commandlog.Command;
import org.simantics.utils.commandlog.Commands;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class DeleteHandler
extends AbstractDiagramParticipant {
    public static final boolean DEBUG_DELETE = false;
    @DependencyReflection.Dependency
    protected Selection sel;
    private final IStatusLineManager statusLine;

    public DeleteHandler(IStatusLineManager statusLine) {
        this.statusLine = statusLine;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent e) {
        if (org.simantics.scenegraph.g2d.events.command.Commands.DELETE.equals((Object)e.command)) {
            IDiagram d = this.diagram;
            if (d == null) {
                return true;
            }
            Set ss = this.sel.getSelection(0);
            if (ss.isEmpty()) {
                return true;
            }
            if (DeleteHandler.delete(d, ss, ex -> {
                if (ex instanceof CannotRemoveException) {
                    ShowMessage.showInformation((String)"Delete Selection Was Denied", (String)ex.getLocalizedMessage());
                }
            }, error -> this.error((String)error))) {
                this.sel.clear(0);
            }
            return true;
        }
        return false;
    }

    public static boolean delete(final IDiagram d, Collection<IElement> ss, final Consumer<Exception> exceptionListener, final Consumer<String> errorListener) {
        TimeLogger.resetTimeAndLog(DeleteHandler.class, (String)"delete");
        Topology topology = (Topology)d.getDiagramClass().getAtMostOneItemOfClass(Topology.class);
        RelationshipHandler erh = (RelationshipHandler)d.getDiagramClass().getAtMostOneItemOfClass(RelationshipHandler.class);
        ArrayDeque<IElement> elementsToProcess = new ArrayDeque<IElement>(ss);
        HashSet<IElement> processedElements = new HashSet<IElement>();
        HashSet<IElement> relationshipsProcessedForElement = new HashSet<IElement>();
        final ArrayList<IElement> elements = new ArrayList<IElement>();
        final HashSet<IElement> edges = new HashSet<IElement>();
        ArrayList connections = new ArrayList();
        ArrayList terminals = new ArrayList();
        ArrayList relations = new ArrayList();
        while (!elementsToProcess.isEmpty()) {
            IElement el = (IElement)elementsToProcess.pollFirst();
            if (relationshipsProcessedForElement.add(el)) {
                relations.clear();
                erh.getRelations(d, (Object)el, relations);
                if (!relations.isEmpty()) {
                    boolean restart = false;
                    for (RelationshipHandler.Relation r : relations) {
                        IElement ee;
                        if (r.getRelationship() != Relationship.PARENT_OF || !(r.getObject() instanceof IElement) || !d.containsElement(ee = (IElement)r.getObject())) continue;
                        elementsToProcess.addFirst(ee);
                        restart = true;
                    }
                    if (restart) {
                        elementsToProcess.addLast(el);
                        continue;
                    }
                }
            }
            if (!processedElements.add(el)) continue;
            TerminalTopology tt = (TerminalTopology)el.getElementClass().getAtMostOneItemOfClass(TerminalTopology.class);
            BendsHandler bh = (BendsHandler)el.getElementClass().getAtMostOneItemOfClass(BendsHandler.class);
            if (bh != null) {
                Topology.Connection begin = topology.getConnection(el, EdgeVisuals.EdgeEnd.Begin);
                Topology.Connection end = topology.getConnection(el, EdgeVisuals.EdgeEnd.End);
                if (begin != null && end != null && PickRequest.PickFilter.FILTER_BRANCH_POINT.accept(begin.node) && PickRequest.PickFilter.FILTER_BRANCH_POINT.accept(end.node)) {
                    if (errorListener != null) {
                        errorListener.accept("Deletion of branch point connecting edges is not allowed. Must be connected to a node terminal.");
                    }
                    return false;
                }
                edges.add(el);
                continue;
            }
            elements.add(el);
            if (tt == null) continue;
            terminals.clear();
            tt.getTerminals(el, terminals);
            connections.clear();
            for (Topology.Terminal terminal : terminals) {
                topology.getConnections(el, terminal, connections);
            }
            for (Topology.Connection c : connections) {
                if (c.edge == null || !c.edge.getElementClass().containsClass(BendsHandler.class)) continue;
                edges.add(c.edge);
            }
        }
        if (elements.isEmpty() && edges.isEmpty()) {
            return false;
        }
        new DatabaseJob("Delete selection"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.delete(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CannotRemoveException e) {
                    if (exceptionListener != null) {
                        exceptionListener.accept(e);
                    }
                    Status status = new Status(8, "org.simantics.diagram", e.getLocalizedMessage(), (Throwable)e);
                    return status;
                }
                catch (DatabaseException e) {
                    if (exceptionListener != null) {
                        exceptionListener.accept(e);
                    }
                    Status status = new Status(4, "org.simantics.diagram", "Unexpected error in delete.", (Throwable)e);
                    return status;
                }
                finally {
                    if (errorListener != null) {
                        errorListener.accept(null);
                    }
                    monitor.done();
                }
            }

            private void delete(IProgressMonitor monitor) throws DatabaseException {
                final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                Simantics.getSession().syncRequest((Write)new WriteRequest(){
                    Set<Resource> connectionsToRemove = new HashSet<Resource>();
                    Set<Resource> touchedConnections = new HashSet<Resource>();

                    public void perform(WriteGraph graph) throws DatabaseException {
                        this.validateRemoval((ReadGraph)graph);
                        graph.markUndoPoint();
                        ConnectionUtil cu = new ConnectionUtil(graph);
                        SubMonitor edgeElementMonitor = subMonitor.split(2);
                        edgeElementMonitor.setWorkRemaining(edges.size() + elements.size());
                        edgeElementMonitor.setTaskName("Removing edges");
                        for (IElement edge : edges) {
                            ConnectionEntity ce = (ConnectionEntity)edge.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                            this.touchConnection(ce.getConnection());
                            Object obj = ElementUtils.getObject((IElement)edge);
                            if (obj instanceof EdgeResource) {
                                cu.remove((EdgeResource)obj);
                            }
                            edgeElementMonitor.worked(1);
                        }
                        edgeElementMonitor.setTaskName("Removing elements");
                        for (IElement element : elements) {
                            ConnectionHandler ch = (ConnectionHandler)element.getElementClass().getAtMostOneItemOfClass(ConnectionHandler.class);
                            if (ch != null) {
                                this.connectionsToRemove.add((Resource)ElementUtils.getObject((IElement)element));
                            } else {
                                ConnectionEntity ce = (ConnectionEntity)element.getHint(ElementHints.KEY_CONNECTION_ENTITY);
                                if (ce != null) {
                                    new RemoveBranchpoint(element).perform(graph);
                                    this.touchConnection(ce.getConnection());
                                } else {
                                    Object obj = ElementUtils.getObject((IElement)element);
                                    if (obj instanceof Resource) {
                                        Collection<Resource> connectors = cu.getTerminalConnectors((Resource)obj, null);
                                        for (Resource connector : connectors) {
                                            Resource connection = ConnectionUtil.tryGetConnection((ReadGraph)graph, connector);
                                            if (connection != null) {
                                                this.touchConnection(connection);
                                            }
                                            cu.disconnectFromAllRouteNodes(connector);
                                        }
                                        if (Commands.isRecording()) {
                                            Commands.record((Object)graph, (Command)new DeleteElementCommand((Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), (Resource)element.getHint(ElementHints.KEY_OBJECT)));
                                        }
                                        new RemoveElement((Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), (Resource)element.getHint(ElementHints.KEY_OBJECT)).perform(graph);
                                    }
                                }
                            }
                            edgeElementMonitor.worked(1);
                        }
                        SubMonitor connectionsMonitor = subMonitor.split(1);
                        connectionsMonitor.setWorkRemaining(this.touchedConnections.size());
                        connectionsMonitor.setTaskName("Pruning connectors");
                        for (Resource connection : this.touchedConnections) {
                            int removedInteriorRouteNodes;
                            int removedConnectors = cu.removeUnusedConnectors(connection);
                            while ((removedInteriorRouteNodes = cu.removeExtraInteriorRouteNodes(connection)) != 0) {
                            }
                            int connectors = cu.getConnectedConnectors(connection, null).size();
                            if (connectors < 2) {
                                this.connectionsToRemove.add(connection);
                            }
                            connectionsMonitor.worked(1);
                        }
                        SubMonitor connectionsMonitor2 = subMonitor.split(1);
                        connectionsMonitor2.setWorkRemaining(this.connectionsToRemove.size());
                        connectionsMonitor2.setTaskName("Removing leftover connections");
                        for (Resource connection : this.connectionsToRemove) {
                            if (Commands.isRecording()) {
                                Commands.record((Object)graph, (Command)new DeleteElementCommand((Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), connection));
                            }
                            RemoveElement.removeElement(graph, (Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), connection);
                            connectionsMonitor2.worked(1);
                        }
                    }

                    private void validateRemoval(ReadGraph graph) throws DatabaseException, CannotRemoveException {
                        ArrayList<String> problems = new ArrayList<String>(elements.size());
                        for (IElement element : elements) {
                            String problem;
                            Remover remover;
                            Object obj = ElementUtils.getObject((IElement)element);
                            if (!(obj instanceof Resource) || (remover = RemoverUtil.getPossibleRemover((ReadGraph)graph, (Resource)((Resource)obj))) == null || (problem = remover.canRemove(graph, new HashMap(4))) == null) continue;
                            problems.add(problem);
                        }
                        if (!problems.isEmpty()) {
                            throw new CannotRemoveException(EString.implode(problems));
                        }
                    }

                    void touchConnection(Object c) {
                        if (c instanceof IElement) {
                            Object obj = ElementUtils.getObject((IElement)((IElement)c));
                            if (obj instanceof Resource) {
                                this.touchedConnections.add((Resource)obj);
                            }
                        } else if (c instanceof Resource) {
                            this.touchedConnections.add((Resource)c);
                        }
                    }
                });
            }
        }.schedule();
        return true;
    }

    void message(final String message) {
        if (this.statusLine == null) {
            return;
        }
        this.swtExec(new Runnable(){

            @Override
            public void run() {
                DeleteHandler.this.statusLine.setMessage(message);
                DeleteHandler.this.statusLine.setErrorMessage(null);
            }
        });
    }

    void error(final String message) {
        if (this.statusLine == null) {
            return;
        }
        this.swtExec(new Runnable(){

            @Override
            public void run() {
                DeleteHandler.this.statusLine.setErrorMessage(message);
            }
        });
    }

    void swtExec(Runnable r) {
        ThreadUtils.asyncExec((IThreadWorkQueue)SWTThread.getThreadAccess((Display)Display.getDefault()), (Runnable)r);
    }
}

