/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.util;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.procedure.TLongObjectProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.DeferredBinaryFile;
import org.simantics.databoard.util.binary.NullRandomAccessBinary;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.DirectStatements;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.SubgraphExtent;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.layer0.util.ComposedTGValueModifier;
import org.simantics.db.layer0.util.DomainProcessor3;
import org.simantics.db.layer0.util.DomainProcessorState;
import org.simantics.db.layer0.util.ModelTransferableGraphSource;
import org.simantics.db.layer0.util.NullOutputStream;
import org.simantics.db.layer0.util.ResourceTGValueModifier;
import org.simantics.db.layer0.util.RevisionTGValueModifier;
import org.simantics.db.layer0.util.TGValueModifier;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.db.request.Read;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.graph.utils.TGResourceUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class ModelTransferableGraphSourceRequest
extends UniqueRead<ModelTransferableGraphSource> {
    public static String LOG_FILE = "transferableGraph.log";
    static final boolean LOG = false;
    static final boolean PRINTDEBUG = false;
    static final boolean DEBUG = false;
    static final boolean PROFILE = false;
    private TransferableGraphConfiguration2 configuration;
    private SubMonitor monitor;
    static DataOutput log;
    Layer0 L0;
    int[] statements;
    int statementIndex = 0;
    TIntIntHashMap ids;
    TIntArrayList externalParents = new TIntArrayList();
    ArrayList<String> externalNames = new ArrayList();
    int id = 0;
    int indent = 0;
    private SerialisationSupport support;

    static void log(String line) {
    }

    public ModelTransferableGraphSourceRequest(TransferableGraphConfiguration2 conf) {
        this(null, conf);
    }

    public ModelTransferableGraphSourceRequest(IProgressMonitor monitor, TransferableGraphConfiguration2 conf) {
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
        this.configuration = conf;
    }

    public int getInternalId(int r) {
        return this.ids.get(r);
    }

    public boolean validateExternal(Resource ext) {
        SubgraphExtent.ExtentStatus status = this.configuration.preStatus.get(ext);
        if (status != null) {
            if (SubgraphExtent.ExtentStatus.INTERNAL.equals((Object)status)) {
                return false;
            }
            if (SubgraphExtent.ExtentStatus.EXCLUDED.equals((Object)status)) {
                return false;
            }
        }
        return true;
    }

    public ModelTransferableGraphSource perform(ReadGraph graph) throws DatabaseException {
        this.support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        long total = System.nanoTime();
        long startupTime = System.nanoTime();
        long startupTimeEnd = System.nanoTime();
        long domainTime = System.nanoTime();
        String otherStatements = "other" + UUID.randomUUID().toString();
        String valueFileName = "value" + UUID.randomUUID().toString();
        File base_ = SimanticsInternal.getTemporaryDirectory();
        File base = new File(base_, "exports");
        base.mkdirs();
        File otherStatementsFile = new File(base, otherStatements);
        File valueFile = new File(base, valueFileName);
        try {
            DeferredFileOutputStream otherStatementsStream = new DeferredFileOutputStream(0x100000, otherStatementsFile);
            DataOutputStream otherStatementsOutput = new DataOutputStream(new BufferedOutputStream((OutputStream)otherStatementsStream, 0x100000));
            DeferredBinaryFile valueOutput = new DeferredBinaryFile(valueFile, 0x100000, 131072);
            ClusterControl cc = (ClusterControl)graph.getService(ClusterControl.class);
            ClusterControl.ClusterState clusterState = cc.getClusterState();
            TIntHashSet excludedShared = new TIntHashSet();
            this.ids = new TIntIntHashMap(1000, 0.75f);
            DomainProcessorState state = new DomainProcessorState();
            state.extensions.putAll(this.configuration.baseExtensions);
            state.ids = this.ids;
            state.statementsOutput = otherStatementsOutput;
            state.valueOutput = valueOutput;
            state.valueCount = 0;
            state.excludedShared = excludedShared;
            state.monitor = this.monitor;
            state.valueModifier = this.composeTGValueModifier(this.configuration.valueModifiers);
            ModelTransferableGraphSourceRequest.getDomain2(graph, this.configuration, state, this.configuration.ignoreVirtualResources);
            this.id = this.ids.size();
            cc.restoreClusterState(clusterState);
            otherStatementsOutput.flush();
            otherStatementsOutput.close();
            valueOutput.flush();
            long domainDuration = System.nanoTime() - domainTime;
            state.id = this.id;
            state.otherStatementsInput = ModelTransferableGraphSourceRequest.toRandomAccessBinary(otherStatementsStream, 131072);
            state.valueInput = ModelTransferableGraphSourceRequest.toRandomAccessBinary(valueOutput);
            state.statementsOutput = null;
            state.valueOutput = null;
            long totalEnd = System.nanoTime();
            return this.getSource(graph, this.configuration, state, otherStatementsFile, valueFile);
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DatabaseException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            SimanticsInternal.dumpHeap((String)"crash.hprof");
            throw new DatabaseException(e.getMessage(), e);
        }
    }

    protected ModelTransferableGraphSource getSource(ReadGraph graph, TransferableGraphConfiguration2 configuration, DomainProcessorState state, File otherStatementsFile, File valueFile) throws DatabaseException {
        return new ModelTransferableGraphSource(graph, configuration, state, otherStatementsFile, valueFile);
    }

    private TGValueModifier composeTGValueModifier(Collection<TGValueModifier> configuredModifiers) {
        int configured = configuredModifiers == null ? 0 : configuredModifiers.size();
        ArrayList<TGValueModifier> valueModifiers = new ArrayList<TGValueModifier>(configured + 2);
        if (configured > 0) {
            valueModifiers.addAll(configuredModifiers);
        }
        valueModifiers.add(new ResourceTGValueModifier(this.support));
        valueModifiers.add(RevisionTGValueModifier.INSTANCE);
        return new ComposedTGValueModifier(valueModifiers.toArray(new TGValueModifier[valueModifiers.size()]));
    }

    private static RandomAccessBinary toRandomAccessBinary(DeferredFileOutputStream stream, int bufferSize) throws IOException {
        if (stream.isInMemory()) {
            return new BinaryMemory(stream.getData());
        }
        return new BinaryFile(stream.getFile(), bufferSize);
    }

    private static RandomAccessBinary toRandomAccessBinary(DeferredBinaryFile file) throws IOException {
        RandomAccessBinary b = file.getBackend();
        long size = b.position();
        b.position(0L);
        if (b instanceof BinaryMemory) {
            b.setLength(size);
        }
        return b;
    }

    public static DomainOnlyProcessor getDomainOnly(RequestProcessor processor, IProgressMonitor monitor, Resource resource) throws DatabaseException {
        return ModelTransferableGraphSourceRequest.getDomainOnly(processor, monitor, Collections.singletonList(resource));
    }

    public static DomainOnlyProcessor getDomainOnly(RequestProcessor processor, final IProgressMonitor monitor, final Collection<Resource> resources) throws DatabaseException {
        return (DomainOnlyProcessor)processor.syncRequest((Read)new UniqueRead<DomainOnlyProcessor>(){

            public DomainOnlyProcessor perform(ReadGraph graph) throws DatabaseException {
                try {
                    TransferableGraphConfiguration2 conf = TransferableGraphConfiguration2.createWithResources((RequestProcessor)graph, resources, Collections.emptyList());
                    conf.values = false;
                    conf.valueIds = false;
                    DomainProcessorState state = new DomainProcessorState();
                    state.extensions.putAll(conf.baseExtensions);
                    state.ids = new TIntIntHashMap(1000, 0.75f);
                    state.statementsOutput = new DataOutputStream(new NullOutputStream());
                    state.valueOutput = new NullRandomAccessBinary();
                    state.valueCount = 0;
                    state.excludedShared = new TIntHashSet();
                    state.monitor = SubMonitor.convert((IProgressMonitor)monitor);
                    return ModelTransferableGraphSourceRequest.getDomainOnly(graph, conf, state, conf.ignoreVirtualResources);
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
        });
    }

    public static DomainOnlyProcessor getDomainOnly(ReadGraph graph, TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
        DomainOnlyProcessor processor = new DomainOnlyProcessor(graph, conf, state, ignoreVirtual);
        ModelTransferableGraphSourceRequest.getDomain2(graph, state, processor);
        return processor;
    }

    public static DomainProcessor3 getDomain2(final ReadGraph graph, TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
        int transientId;
        SubgraphExtent.ExtentStatus status;
        ITask task = ThreadLogger.getInstance().begin("getDomain2");
        final DomainProcessor3 processor = new DomainProcessor3(graph, conf, state, ignoreVirtual);
        ModelTransferableGraphSourceRequest.getDomain2(graph, state, processor);
        final SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        final ClusteringSupport cls = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        final Resource indexRoot = processor.conf.indexRoot;
        if (state.monitor.isCanceled()) {
            throw new CancelTransactionException();
        }
        TLongObjectHashMap clusterMap = new TLongObjectHashMap();
        for (Resource r : processor.status.keySet()) {
            status = (SubgraphExtent.ExtentStatus)((Object)processor.status.get((Object)r));
            transientId = support.getTransientId(r);
            if (SubgraphExtent.ExtentStatus.INTERNAL == status) {
                long cluster = cls.getCluster(r);
                TIntArrayList list = (TIntArrayList)clusterMap.get(cluster);
                if (list == null) {
                    list = new TIntArrayList();
                    clusterMap.put(cluster, (Object)list);
                }
                list.add(transientId);
                continue;
            }
            if (SubgraphExtent.ExtentStatus.EXTERNAL == status) {
                state.externals.add(transientId);
                continue;
            }
            if (SubgraphExtent.ExtentStatus.PENDING != status) continue;
            String uri = graph.getPossibleURI(r);
            if (uri != null) {
                processor.status.put((Object)r, (Object)SubgraphExtent.ExtentStatus.EXTERNAL);
                if (!conf.includePendingWeakReferences) continue;
                state.externals.add(transientId);
                continue;
            }
            state.pending.add(transientId);
            System.err.println("Pending status in export: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)r, (boolean)true) + " (" + graph.getPossibleURI(r) + ")");
        }
        for (Statement stm : processor.unresolvedWeakLinks) {
            status = (SubgraphExtent.ExtentStatus)((Object)processor.status.get((Object)stm.getObject()));
            if (SubgraphExtent.ExtentStatus.INTERNAL == status) {
                transientId = support.getTransientId(stm.getSubject());
                processor.addToStream(stm.getPredicate(), stm.getObject(), state);
                try {
                    processor.flushStatementStream(transientId, state);
                    continue;
                }
                catch (IOException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
            if (SubgraphExtent.ExtentStatus.EXTERNAL != status || !conf.includePendingWeakReferences) continue;
            transientId = support.getTransientId(stm.getSubject());
            processor.addToStream(stm.getPredicate(), stm.getObject(), state);
            try {
                processor.flushStatementStream(transientId, state);
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        if (state.monitor.isCanceled()) {
            throw new CancelTransactionException();
        }
        final TIntArrayList clustering = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                clustering.add(b.size());
                b.forEach(new TIntProcedure(){

                    public boolean execute(int rId) {
                        processor.ids.put(rId, processor.id++);
                        return true;
                    }
                });
                return true;
            }
        });
        if (state.monitor.isCanceled()) {
            throw new CancelTransactionException();
        }
        final TIntArrayList clusterSets = new TIntArrayList();
        clusterMap.forEachEntry((TLongObjectProcedure)new TLongObjectProcedure<TIntArrayList>(){

            public boolean execute(long cluster, TIntArrayList b) {
                block5: {
                    Resource clusterSet;
                    block7: {
                        block6: {
                            try {
                                clusterSet = cls.getClusterSetOfCluster(cluster);
                                if (clusterSet == null) break block5;
                                int transientId = support.getTransientId(clusterSet);
                                if (!processor.ids.containsKey(transientId)) break block6;
                                clusterSets.add(processor.ids.get(transientId));
                                return true;
                            }
                            catch (DatabaseException databaseException) {}
                        }
                        if (!graph.getRootLibrary().equals(clusterSet)) break block7;
                        clusterSets.add(-1);
                        return true;
                    }
                    if (clusterSet.equals(indexRoot)) {
                        clusterSets.add(-2);
                        return true;
                    }
                }
                clusterSets.add(-1);
                return true;
            }
        });
        state.extensions.put("clustering", new Variant((Binding)Bindings.INT_ARRAY, (Object)clustering.toArray()));
        state.extensions.put("clusterSets", new Variant((Binding)Bindings.INT_ARRAY, (Object)clusterSets.toArray()));
        long total = processor.startupTime + processor.expandTime + processor.classifyPredicateTime + processor.processFringeTime + processor.extentSeedTime + processor.fullResolveTime + processor.fastResolveTime + processor.parentResolveTime + processor.otherStatementTime;
        task.finish();
        return processor;
    }

    public static DomainProcessor3 getDomain2(ReadGraph graph, DomainProcessorState state, DomainProcessor3 processor) throws DatabaseException {
        processor.process(graph, state);
        return processor;
    }

    public static void main(String[] args) {
        try {
            Datatype dt = Datatypes.translate((String)"{ parts : ( | ResourceRVIPart { role : |CHILD|PROPERTY, resource : Long(unit=\"resource\") } | StringRVIPart { role : |CHILD|PROPERTY, string : String } ) [] }");
            Binding b = Bindings.getBinding((Datatype)dt);
            Object value = b.createDefault();
            Variant variant = new Variant(b, value);
            TGResourceUtil util = new TGResourceUtil();
            TGResourceUtil.LongAdapter la = new TGResourceUtil.LongAdapter(){

                public long adapt(long in) {
                    return in;
                }
            };
            util.adaptValue(variant.getBinding(), variant.getValue(), la);
        }
        catch (DataTypeSyntaxError e) {
            e.printStackTrace();
        }
        catch (BindingException e) {
            e.printStackTrace();
        }
        catch (RuntimeSerializerConstructionException e) {
            e.printStackTrace();
        }
        catch (AccessorException e) {
            e.printStackTrace();
        }
    }

    public static class DomainOnlyProcessor
    extends DomainProcessor3 {
        final Resource instanceOf;
        public final List<Resource> internals;
        public final List<Resource> internalTypes;
        private int counter = 0;

        public DomainOnlyProcessor(ReadGraph graph, TransferableGraphConfiguration2 conf, DomainProcessorState state, boolean ignoreVirtual) throws DatabaseException {
            super(graph, conf, state, ignoreVirtual);
            CollectionSupport cs = (CollectionSupport)graph.getService(CollectionSupport.class);
            this.internals = cs.createList();
            this.internalTypes = cs.createList();
            this.instanceOf = Layer0.getInstance((ReadGraph)graph).InstanceOf;
        }

        @Override
        public final void addToStream(Resource predicate, Resource object, DomainProcessorState state) throws DatabaseException {
        }

        @Override
        public void flushStatementStream(int sId, DomainProcessorState state) throws IOException {
        }

        @Override
        public void processValue(ReadGraph graph, Resource subject, int sId, DomainProcessorState state) throws DatabaseException, IOException {
        }

        @Override
        public void processInternal(ReadGraph graph, Resource subject, DirectStatements stms, DomainProcessorState state) throws DatabaseException, IOException {
            if ((this.counter++ & 0x3FF) == 0 && state.monitor != null && state.monitor.isCanceled()) {
                throw new CancelTransactionException();
            }
            super.processInternal(graph, subject, stms, state);
            this.internals.add(subject);
            Resource singleType = null;
            for (Statement s : stms) {
                if (!this.instanceOf.equals(s.getPredicate())) continue;
                if (singleType != null) {
                    this.internalTypes.add(null);
                    return;
                }
                singleType = s.getObject();
            }
            this.internalTypes.add(singleType);
        }
    }

    static class Expansion3
    extends UniqueRead<Collection<DirectStatements>> {
        private final Collection<Resource> roots;
        final boolean ignoreVirtual;

        public Expansion3(Collection<Resource> roots, boolean ignoreVirtual) {
            this.roots = roots;
            this.ignoreVirtual = ignoreVirtual;
        }

        public Collection<DirectStatements> perform(ReadGraph graph) {
            ArrayList<DirectStatements> result = new ArrayList<DirectStatements>();
            DirectQuerySupport dqs = (DirectQuerySupport)graph.getService(DirectQuerySupport.class);
            if (this.ignoreVirtual) {
                for (Resource r : this.roots) {
                    result.add(dqs.getDirectPersistentStatements(graph, r));
                }
            } else {
                for (Resource r : this.roots) {
                    result.add(dqs.getDirectStatements(graph, r));
                }
            }
            return result;
        }
    }
}

