/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver.formula;

import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.CellFormulaFunction;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.FormulaError2;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

class SumifFormulaFunction
implements CellFormulaFunction<Object> {
    SumifFormulaFunction() {
    }

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() == 2) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            }
            catch (IllegalStateException illegalStateException) {
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if (error != null) {
                return error.getString();
            }
            if (test instanceof SpreadsheetMatrix) {
                double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix)test;
                int i = 0;
                while (i < tm.values.length) {
                    double d;
                    if (Spreadsheets.matchCriteria(tm.values[i], criteria) && Double.isFinite(d = Spreadsheets.asNumber(tm.values[i]))) {
                        sum += d;
                    }
                    ++i;
                }
                return sum;
            }
            Double d = Spreadsheets.asNumber(test);
            return d;
        }
        if (args.values.size() == 3) {
            Object test = args.values.get(0).accept(visitor);
            Object criteria = null;
            try {
                criteria = args.values.get(1).accept(visitor);
            }
            catch (IllegalStateException illegalStateException) {
                return 0;
            }
            FormulaError2 error = FormulaError2.forObject(criteria);
            if (error != null) {
                return error.getString();
            }
            Object range = args.values.get(2).accept(visitor);
            if (test instanceof SpreadsheetMatrix) {
                Double sum = 0.0;
                SpreadsheetMatrix tm = (SpreadsheetMatrix)test;
                SpreadsheetMatrix rm = (SpreadsheetMatrix)range;
                int i = 0;
                while (i < tm.values.length) {
                    double d;
                    if (Spreadsheets.matchCriteria(tm.values[i], criteria) && Double.isFinite(d = Spreadsheets.asNumber(rm.values[i]))) {
                        sum = sum + d;
                    }
                    ++i;
                }
                return sum;
            }
            Double d = Spreadsheets.asNumber(test);
            return d;
        }
        throw new IllegalStateException();
    }
}

