/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.Bundle;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modelica.ModelicaException;
import org.simantics.modelica.ModelicaKeys;
import org.simantics.modelica.SimulationLocation;
import org.simantics.modelica.preferences.OpenModelicaPreferences;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ModelicaManager {
    private static final String OM_BUILTIN = "OM192";
    public static final String OMC_VERSION = "OMC_VERSION";
    public static final String RESULT_FILE_NAME = "RESULT_FILE_NAME";

    private static boolean onWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    private static File getOMCBinary(File home) {
        return new File(home, "bin" + File.separator + "omc" + (ModelicaManager.onWindows() ? ".exe" : ""));
    }

    private static Process runWithEnvironment(File homeDir, File workDir, File executable, String ... parameters) throws IOException {
        if (!executable.isFile() && !executable.canExecute()) {
            throw new FileNotFoundException("executable " + executable.getAbsolutePath() + " not found");
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(executable.getAbsolutePath());
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            command.add(parameter);
            ++n2;
        }
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.directory(workDir);
        Map<String, String> env = builder.environment();
        env.put("OPENMODELICAHOME", homeDir.getAbsolutePath());
        File lib = new File(homeDir, "lib");
        File omlib = new File(lib, "omlibrary");
        env.put("OPENMODELICALIBRARY", omlib.getAbsolutePath());
        File bin = new File(homeDir, "bin");
        env.put("OMPATH", bin.getAbsolutePath());
        File mingw = new File(homeDir, "MinGW");
        env.put("MINGW", mingw.getAbsolutePath());
        File mbin = new File(mingw, "bin");
        File mlib = new File(mingw, "lib");
        String path_allcaps = env.get("PATH") == null ? "" : env.get("PATH") + File.pathSeparator;
        env.put("PATH", path_allcaps + bin.getAbsolutePath() + File.pathSeparator + mbin.getAbsolutePath() + File.pathSeparator + mlib.getAbsolutePath());
        String path = env.get("Path") == null ? "" : env.get("Path") + File.pathSeparator;
        env.put("Path", path + bin.getAbsolutePath() + File.pathSeparator + mbin.getAbsolutePath() + File.pathSeparator + mlib.getAbsolutePath());
        env.put("MODELICAUSERCFLAGS", "-O0");
        Process process = null;
        process = builder.start();
        return process;
    }

    private static Process runOMC(File homeDir, File workDir, String ... parameters) throws IOException {
        return ModelicaManager.runWithEnvironment(homeDir, workDir, ModelicaManager.getOMCBinary(homeDir), parameters);
    }

    public static String getOMVersion(File home) {
        try {
            return ModelicaManager.getProcessOutput(ModelicaManager.runOMC(home, home, "--version"));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getDefaultOMVersion() {
        return ModelicaManager.getOMVersion(ModelicaManager.getOMHome());
    }

    public static boolean isOldOMVersion() {
        return false;
    }

    public static File getOMHome() {
        File omHome;
        IEclipsePreferences node = ConfigurationScope.INSTANCE.getNode("org.simantics.modelica");
        String omHomePath = node.get(OpenModelicaPreferences.OM_HOME, null);
        if (omHomePath != null && (omHome = new File(omHomePath)).isDirectory()) {
            return omHome;
        }
        return ModelicaManager.getDefaultOMHome();
    }

    public static File getDefaultOMHome() {
        File builtin;
        if (ModelicaManager.onWindows() && (builtin = ModelicaManager.getBuiltinOMHome()) != null) {
            return builtin;
        }
        File installed = ModelicaManager.getInstalledOMHome();
        if (installed != null) {
            return installed;
        }
        return null;
    }

    public static File getInstalledOMHome() {
        File omHome;
        String omHomePath = System.getenv("OPENMODELICAHOME");
        if (omHomePath != null && (omHome = new File(omHomePath)).isDirectory()) {
            return omHome;
        }
        return null;
    }

    public static File getBuiltinOMHome() {
        Bundle bundle = Platform.getBundle((String)"org.simantics.om.win32");
        if (bundle != null) {
            try {
                File omHome = new File(FileLocator.getBundleFile((Bundle)bundle), OM_BUILTIN);
                if (omHome.isDirectory()) {
                    return omHome;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getProcessOutput(Process process) throws IOException {
        String lf = System.getProperty("line.separator");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            StringBuilder output = new StringBuilder();
            boolean first = true;
            while ((line = input.readLine()) != null) {
                if (!first) {
                    output.append(lf);
                }
                first = false;
                output.append(line);
            }
            return output.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void printProcessOutput(final Process process, final IModelicaMonitor monitor) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                InputStream stream = process.getInputStream();
                StringBuilder b = new StringBuilder();
                try {
                    int c;
                    while ((c = stream.read()) > 0) {
                        if (monitor == null) continue;
                        if ((char)c != '\n') {
                            b.append((char)c);
                            continue;
                        }
                        System.out.println("OMC output: " + b.toString());
                        String message = b.toString();
                        message = message.trim();
                        if (message.startsWith("\"")) {
                            message = message.substring(1);
                        }
                        monitor.message(message);
                        b.delete(0, b.length());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        thread.run();
    }

    public static SimulationLocation createSimulationLocation(File modelDir, String modelName, String modelContent) {
        if (!modelDir.isDirectory()) {
            return null;
        }
        modelName = modelName.replace(" ", "");
        SimulationLocation location = new SimulationLocation(modelDir, modelName);
        location.modelFile = location.getFileInLocation(".mo");
        location.modelScriptFile = location.getFileInLocation(".mos");
        try {
            FileWriter writer = new FileWriter(location.modelFile);
            writer.write(modelContent);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (ModelicaManager.isOldOMVersion()) {
            location.fullModelDir = new File(location.getModelDir(), "fullModel");
            if (!location.fullModelDir.isDirectory()) {
                location.fullModelDir.mkdir();
            }
            location.fullModelFile = new File(location.fullModelDir, location.getModelName() + "_full.mo");
            location.fullModelScriptFile = new File(location.fullModelDir, location.getModelName() + "_full.mos");
        }
        location.omHome = ModelicaManager.getOMHome();
        return location;
    }

    public static void createSimulationScripts(SimulationLocation location, HashMap<String, String> parameters, String additionalScript) throws FileNotFoundException {
        ModelicaManager.writeScriptFile(location, parameters, additionalScript);
        location.executableFile = location.getFileInLocation(ModelicaManager.onWindows() ? ".exe" : "");
        location.initFile = location.getFileInLocation("_init.xml");
        location.resultFile = location.getFileInLocation("_res." + parameters.get(ModelicaKeys.OUTPUT_FORMAT));
        if (ModelicaManager.isOldOMVersion()) {
            ModelicaManager.writeFullModelScriptFile(location, additionalScript);
        }
    }

    public static void createFMUSimulationScripts(SimulationLocation location, HashMap<String, String> parameters, String additionalScript) throws FileNotFoundException {
        ModelicaManager.writeFMUScriptFile(location, additionalScript);
        location.executableFile = location.getFileInLocation(".fmu");
        location.initFile = location.getFileInLocation("_init.xml");
        location.resultFile = location.getFileInLocation("_res." + parameters.get(ModelicaKeys.OUTPUT_FORMAT));
        if (ModelicaManager.isOldOMVersion()) {
            ModelicaManager.writeFullModelScriptFile(location, additionalScript);
        }
    }

    private static void writeScriptFile(SimulationLocation location, HashMap<String, String> parameters, String additionalScript) throws FileNotFoundException {
        PrintStream s = new PrintStream(location.modelScriptFile);
        s.println("loadFile(\"" + location.modelFile.getName() + "\");");
        if (additionalScript != null) {
            s.println(additionalScript);
        }
        s.print("buildModel(" + location.getModelName());
        s.print(",startTime=" + parameters.get(ModelicaKeys.START_VALUE));
        s.print(",stopTime=" + parameters.get(ModelicaKeys.STOP_VALUE));
        s.print(",method=" + parameters.get(ModelicaKeys.METHOD));
        s.print(",outputFormat=\"" + parameters.get(ModelicaKeys.OUTPUT_FORMAT) + "\"");
        s.print(",cflags=\"-O0\"");
        if (parameters.containsKey(ModelicaKeys.TOLERANCE)) {
            s.print(",tolerance=" + parameters.get(ModelicaKeys.TOLERANCE));
        }
        if (parameters.containsKey(ModelicaKeys.NUMBER_OF_INTERVALS)) {
            s.print(",numberOfIntervals=" + parameters.get(ModelicaKeys.NUMBER_OF_INTERVALS));
        }
        if (parameters.containsKey(ModelicaKeys.VARIABLE_FILTER)) {
            s.print(",variableFilter=\"" + parameters.get(ModelicaKeys.VARIABLE_FILTER) + "\"");
        }
        s.print(");\n");
        s.println("getErrorString();");
        s.close();
    }

    private static void writeFMUScriptFile(SimulationLocation location, String additionalScript) throws FileNotFoundException {
        PrintStream s = new PrintStream(location.modelScriptFile);
        s.println("loadFile(\"" + location.modelFile.getName() + "\");");
        if (additionalScript != null) {
            s.println(additionalScript);
        }
        s.println("translateModelFMU(" + location.getModelName() + ");");
        s.println("getErrorString();");
        s.close();
    }

    private static void writeFullModelScriptFile(SimulationLocation location, String additionalScript) throws FileNotFoundException {
        PrintStream s = new PrintStream(location.fullModelScriptFile);
        s.println("loadFile(\"" + location.modelFile.getName() + "\");");
        if (additionalScript != null) {
            s.println(additionalScript);
        }
        s.print("saveTotalSCode(");
        s.print("\"" + location.fullModelDir.getName() + "/" + location.fullModelFile.getName() + "\"");
        s.print(", ");
        s.print(location.getModelName());
        s.print(");\n");
        s.println("getErrorString();");
        s.close();
    }

    public static void buildFullModel(SimulationLocation location, IModelicaMonitor monitor) throws ModelicaException {
        try {
            Process process = ModelicaManager.runOMC(location.omHome, location.getModelDir(), location.fullModelScriptFile.getAbsolutePath());
            ModelicaManager.printProcessOutput(process, monitor);
            process.waitFor();
            ModelicaManager.trimExtraFromFullModel(location);
        }
        catch (IOException ex) {
            throw new ModelicaException(ex);
        }
        catch (InterruptedException ex) {
            throw new ModelicaException(ex);
        }
    }

    private static void trimExtraFromFullModel(SimulationLocation location) {
        try {
            String textinLine;
            FileInputStream fs = new FileInputStream(location.fullModelFile);
            InputStreamReader in = new InputStreamReader(fs);
            BufferedReader br = new BufferedReader(in);
            StringBuffer sb = new StringBuffer();
            boolean openmodelicaflag = false;
            int breakpoint = 0;
            while ((textinLine = br.readLine()) != null) {
                if (openmodelicaflag) {
                    breakpoint = sb.length();
                    openmodelicaflag = false;
                }
                if (textinLine.contains("end OpenModelica;")) {
                    openmodelicaflag = true;
                }
                sb.append(textinLine + "\n");
            }
            br.close();
            in.close();
            fs.close();
            FileWriter fstream = new FileWriter(location.fullModelFile);
            BufferedWriter outobj = new BufferedWriter(fstream);
            outobj.write(sb.substring(breakpoint));
            outobj.close();
            fstream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void buildModel(SimulationLocation location, IModelicaMonitor monitor) throws ModelicaException {
        try {
            Process process = ModelicaManager.runOMC(location.omHome, location.getModelDir(), location.modelScriptFile.getAbsolutePath());
            ModelicaManager.printProcessOutput(process, monitor);
            process.waitFor();
            if (!location.executableFile.isFile()) {
                throw new ModelicaException("executable file not created");
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new ModelicaException(ex);
        }
    }

    public static Process runModelica(SimulationLocation location, IModelicaMonitor monitor, HashMap<String, String> experimentParameters, HashMap<String, String> parameterChanges) throws IOException {
        ArrayList<CallSite> commands = new ArrayList<CallSite>();
        if (experimentParameters.get(RESULT_FILE_NAME) != null) {
            commands.add((CallSite)((Object)("-r=" + experimentParameters.get(RESULT_FILE_NAME))));
        }
        ModelicaManager.updateInitFile(location, experimentParameters, parameterChanges);
        String[] commandString = new String[commands.size()];
        int i = 0;
        while (i < commands.size()) {
            commandString[i] = (String)commands.get(i);
            ++i;
        }
        return ModelicaManager.runWithEnvironment(location.omHome, location.getModelDir(), location.executableFile, commandString);
    }

    public static String getFlatModelText(SimulationLocation location, IModelicaMonitor monitor, List<String> additional) throws IOException {
        String[] command = new String[additional.size() + 1];
        command[0] = location.modelFile.getAbsolutePath();
        int i = 0;
        while (i < additional.size()) {
            command[i + 1] = additional.get(i);
            ++i;
        }
        return ModelicaManager.getProcessOutput(ModelicaManager.runOMC(location.omHome, location.getModelDir(), command));
    }

    public static HashMap<String, String> getModelParameters(String model) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(model));
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).startsWith("parameter") || !line.contains("=") || !line.contains(";")) continue;
                String[] split = line.split(" = ");
                String name = split[0].trim();
                name = name.substring(name.lastIndexOf(" ") + 1);
                String value = split[1].trim();
                value = value.substring(0, value.indexOf(";"));
                result.put(name, value);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void updateInitFile(SimulationLocation simulationLocation, HashMap<String, String> experimentParameters, HashMap<String, String> parameterChanges) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            Document init = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(simulationLocation.initFile);
            for (String key : experimentParameters.keySet()) {
                Node parameter = (Node)xpath.evaluate("fmiModelDescription/DefaultExperiment/@" + key, init, XPathConstants.NODE);
                if (parameter == null) continue;
                parameter.setNodeValue(experimentParameters.get(key));
            }
            for (String name : parameterChanges.keySet()) {
                Node node = (Node)xpath.evaluate("//fmiModelDescription/ModelVariables/ScalarVariable[@name='" + name + "']/Real/@start", init, XPathConstants.NODE);
                if (node == null) continue;
                node.setNodeValue(parameterChanges.get(name));
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(init), new StreamResult(simulationLocation.initFile));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static enum OSType {
        APPLE,
        LINUX,
        SUN,
        WINDOWS,
        UNKNOWN;

    }
}

