/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.migration.ui;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Read;
import org.simantics.layer0.SoftwareConfigurationResources;
import org.simantics.migration.ui.Messages;
import org.simantics.migration.ui.MigrationAnalysis;

public class MigrateActionFactory
implements ActionFactory {
    public Runnable create(Object target) {
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                MigrateActionFactory.this.analyze(resource);
            }
        };
    }

    private void analyze(final Resource resource) {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SoftwareConfigurationResources SC = SoftwareConfigurationResources.getInstance((ReadGraph)graph);
                final ArrayList<MigrationAnalysis.Update> updates = new ArrayList<MigrationAnalysis.Update>();
                for (Resource version : graph.getObjects(resource, SC.IsCompatibleWith)) {
                    MigrationAnalysis analysis = new MigrationAnalysis(graph, version);
                    updates.addAll(analysis.getUpdates());
                }
                Collections.sort(updates);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MigrateActionFactory.this.select(resource, updates);
                    }
                });
            }
        });
    }

    private void select(Resource resource, final ArrayList<MigrationAnalysis.Update> updates) {
        Object[] result;
        ListDialog listDialog = new ListDialog(Display.getCurrent().getActiveShell());
        listDialog.setTitle(Messages.MigrateActionFactory_Migrate);
        listDialog.setMessage(Messages.MigrateActionFactory_MigrateMsg);
        listDialog.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return updates.toArray();
            }
        });
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MigrationAnalysis.Update)element).versionName;
            }
        });
        listDialog.setInput(updates);
        if (listDialog.open() == 0 && (result = listDialog.getResult()).length == 1) {
            MigrationAnalysis.Update update = (MigrationAnalysis.Update)result[0];
            try {
                update.execute(resource);
                update.updateTargetVersion(resource);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }
}

