/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.modelBrowser.contributions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.datastructures.ArrayMap;

public enum RunLabelRule implements LabelRule
{
    INSTANCE;

    static final SimpleDateFormat HHmmss;

    static {
        HHmmss = new SimpleDateFormat("HH:mm:ss");
    }

    public static RunLabelRule get() {
        return INSTANCE;
    }

    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Long activationTime;
        Resource run = (Resource)content;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Object label = (String)graph.getPossibleRelatedValue2(run, L0.HasLabel);
        if (label == null) {
            return ArrayMap.make((Object[])ColumnKeys.KEYS_SINGLE, (Object[])new String[]{""});
        }
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        if (SIMU.HasActivationTime != null && (activationTime = (Long)graph.getPossibleRelatedValue(run, SIMU.HasActivationTime, (Binding)Bindings.LONG)) != null) {
            String time = HHmmss.format(new Date(activationTime));
            label = (String)label + " (" + time + ")";
        }
        return ArrayMap.make((Object[])ColumnKeys.KEYS_SINGLE, (Object[])new String[]{label});
    }
}

