/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.ArrayList;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.GetStatements;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceElement;
import org.simantics.db.procore.cluster.Statement;
import org.simantics.db.procore.cluster.ValueTable;

public final class ResourceTable
extends Table<long[]> {
    static final int RESOURCE_COUNT_INDEX = 0;
    static final int FOREIGN_COUNT_INDEX = 1;
    static final int CLUSTER_STATUS_INDEX = 2;

    public ResourceTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase);
    }

    public ResourceTable(TableSizeListener sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, (Object)longs);
    }

    public int getUsedSize() {
        return this.getTableCount();
    }

    public short createResource() {
        int INDEX = this.getTableCount();
        int SIZE = ResourceElement.getSizeOf();
        int resourceIndex = this.createNewElement(SIZE);
        assert (resourceIndex != 0);
        int REAL_INDEX = this.checkIndexAndGetRealIndex(resourceIndex, SIZE);
        ResourceElement.construct((long[])this.getTable(), REAL_INDEX);
        this.incResourceCount();
        return (short)(INDEX + 1);
    }

    void createResource(int resourceIndex) {
        int tableCount = this.getTableCount();
        if (resourceIndex <= tableCount) {
            int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
            if (ResourceElement.isEmpty((long[])this.getTable(), realIndex)) {
                return;
            }
        }
        if (resourceIndex == tableCount + 1) {
            this.createResource();
            return;
        }
        throw new InternalError("Trying to create resource with illegal index=" + resourceIndex);
    }

    public int getCompleteObjectRef(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.getCompleteObjectRef((long[])this.getTable(), realIndex);
    }

    public int getPredicateIndex(int resourceIndex) {
        int i = (resourceIndex << 2) - 3 + this.offset;
        return (int)((long[])this.table)[i];
    }

    public void setPredicateIndex(int resourceIndex, int predicateIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElement.setPredicateIndex((long[])this.getTable(), realIndex, predicateIndex);
    }

    public byte[] getValue(ValueTable valueTable, int resourceIndex) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.getValue(valueTable, (long[])this.getTable(), realIndex);
    }

    public boolean hasValue(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.hasValue((long[])this.getTable(), realIndex);
    }

    public boolean removeValue(ValueTable valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean ret = ResourceElement.removeValue(valueTable, (long[])this.getTable(), realIndex);
        return ret;
    }

    public void setValue(ValueTable valueTable, int resourceIndex, byte[] value, int length) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElement.setValue(valueTable, (long[])this.getTable(), realIndex, value, length);
    }

    public boolean isValueEx(ValueTable valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.isValueEx(valueTable, (long[])this.getTable(), realIndex);
    }

    public void setValueEx(ValueTable valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElement.setValueEx(valueTable, (long[])this.getTable(), realIndex);
    }

    int incResourceCount() {
        int count = this.getExtra(0) + 1;
        this.setExtra(0, count);
        return count;
    }

    public int getResourceCount() {
        return this.getExtra(0);
    }

    public int getClusterStatus() {
        return this.getExtra(2);
    }

    public void setClusterStatus(int value) {
        this.setExtra(2, value);
    }

    void analyse() {
        int tsize = this.getTableSize();
        int esize = ResourceElement.getSizeOf();
        long[] table = (long[])this.getTable();
        int i = this.getTableBase();
        while (i < this.getTableBase() + tsize) {
            if (ResourceElement.isUsed((long[])this.getTable(), i)) {
                System.out.println("  -" + Long.toHexString(table[i]) + " " + Long.toHexString(table[i + 1]) + " " + Long.toHexString(table[i + 2]) + " " + Long.toHexString(table[i + 3]));
            }
            i += esize;
        }
    }

    public <Context> boolean foreachResource(ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        int tsize = this.getTableSize();
        int esize = ResourceElement.getSizeOf();
        int key = 1;
        int i = this.getTableBase();
        while (i < this.getTableBase() + tsize) {
            int ref;
            if (ResourceElement.isUsed((long[])this.getTable(), i) && procedure.execute(context, ref = modifier == null ? key : modifier.execute(key))) {
                return true;
            }
            i += esize;
            ++key;
        }
        return false;
    }

    public <Context> boolean foreachPredicate(int resourceIndex, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.foreachPredicate((long[])this.getTable(), realIndex, procedure, context, support, modifier, ct);
    }

    public int getSingleObject(int resourceIndex, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        return ResourceElement.getSingleObject((long[])this.table, 4 * resourceIndex - 3 + this.offset, support, pRef, pCompleteType, ct, modifier);
    }

    public void foreachObject(int resourceIndex, ReadGraphImpl graph, SyncMultiProcedure<Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElement.foreachObject((long[])this.table, realIndex, graph, procedure, support, pRef, pCompleteType, ct, modifier);
    }

    public <C> void foreachObject(int resourceIndex, ReadGraphImpl graph, C context, SyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElement.foreachObject((long[])this.table, realIndex, graph, context, procedure, support, pRef, pCompleteType, ct, modifier);
    }

    public <Context> boolean foreachObject(int resourceIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, int pRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.foreachObject((long[])this.table, realIndex, procedure, context, support, modifier, pRef, completeType, ct);
    }

    public int addStatement(int resourceIndex, int pRef, int oRef, PredicateTable pt, ObjectTable ot, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElement.addStatement((long[])this.getTable(), realIndex, pRef, oRef, pt, ot, pCompleteType, ct);
    }

    public boolean removeStatementFromCache(int resourceIndex, int pRef, int oRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean ret = ResourceElement.removeStatement((long[])this.getTable(), realIndex, pRef, oRef, pCompleteType, ct);
        return ret;
    }

    public void removeStatement(int resourceIndex, int pRef, int oRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, PredicateTable pt, ObjectTable ot, ClusterBase cluster, ClusterSupport support) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean removed = ResourceElement.removeStatement((long[])this.getTable(), realIndex, pRef, oRef, pCompleteType, ct);
        if (!removed) {
            return;
        }
        int predicateIndex = ResourceElement.getPredicateIndex((long[])this.getTable(), realIndex);
        if (predicateIndex == 0) {
            return;
        }
        GetStatements gs = new GetStatements(ot);
        pt.foreachPredicate(predicateIndex, gs, null, null, null);
        ArrayList<Statement> stms = gs.getStatements();
        int SIZE = stms.size();
        if (SIZE < 3) {
            int i = 0;
            while (i < SIZE) {
                Statement stm = stms.get(i);
                PredicateTable.Status ret = pt.removePredicate(predicateIndex, stm.pRef, stm.oIndex, ot);
                if (ret == PredicateTable.Status.NothingRemoved) {
                    throw new DatabaseException("Internal error during statement cache fix (2).");
                }
                int predicateKey = cluster.makeResourceKey(stm.pRef);
                int completeTypeInt = ClusterTraitsBase.getCompleteTypeIntFromResourceKey((int)predicateKey);
                ClusterI.CompleteTypeEnum completeType = ClusterI.CompleteTypeEnum.make((int)completeTypeInt);
                int pi = ResourceElement.addStatement((long[])this.getTable(), realIndex, stm.pRef, stm.oIndex, pt, ot, completeType, ct);
                assert (pi <= 0);
                ++i;
            }
            assert (pt.getPredicateSetSize(predicateIndex) == 0);
        } else {
            int i = 0;
            while (i < SIZE) {
                Statement stm = stms.get(i);
                int predicateKey = cluster.makeResourceKey(stm.pRef);
                int completeTypeInt = ClusterTraitsBase.getCompleteTypeIntFromResourceKey((int)predicateKey);
                ClusterI.CompleteTypeEnum completeType = ClusterI.CompleteTypeEnum.make((int)completeTypeInt);
                int pIndex = ResourceElement.addStatement((long[])this.getTable(), realIndex, stm.pRef, stm.oIndex, pt, ot, completeType, ct);
                if (pIndex > 0) {
                    return;
                }
                ++i;
            }
            throw new DatabaseException("Internal error during statement cache fix (3).");
        }
        ResourceElement.setPredicateIndex((long[])this.getTable(), realIndex, 0);
    }

    private int checkIndexAndGetRealIndex(int INDEX) {
        assert (INDEX > 0);
        assert (INDEX <= this.getTableCount());
        return 4 * INDEX - 3 + this.offset;
    }

    public void check(ClusterBase cluster) throws DatabaseException {
        cluster.checkValueInit();
        long[] table = (long[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int TABLE_SIZE = this.getTableSize();
        int pe = ps + TABLE_SIZE;
        int p = ps;
        while (p < pe) {
            if (ResourceElement.isUsed(table, p)) {
                int pi;
                int cr = ResourceElement.getCompleteObjectRef(table, p);
                if (cr != 0) {
                    if (ClusterTraits.completeReferenceIsMultiple(cr)) {
                        cluster.checkCompleteSetReference(cr);
                    } else {
                        int fi = ClusterTraits.completeReferenceGetForeignIndex(cr);
                        int ri = ClusterTraits.completeReferenceGetResourceIndex(cr);
                        if (fi != 0) {
                            cluster.checkForeingIndex(fi);
                        } else if (ri < 1 || ri > TABLE_SIZE) {
                            throw new ValidationException("Illegal resource index=" + ri);
                        }
                    }
                }
                if ((pi = ResourceElement.getPredicateIndex(table, p)) != 0) {
                    cluster.checkPredicateIndex(pi);
                }
                ResourceElement.ValueData vd = new ResourceElement.ValueData();
                ResourceElement.getValueCapacityAndIndex(vd, table, p);
                cluster.checkValue(vd.capacity, vd.index);
            }
            p += ResourceElement.getSizeOf();
        }
        cluster.checkValueFini();
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}

