/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.InitValueSupport;

public class SymbolMonitorNode
extends ComponentNode<JTextField>
implements ActionListener,
FocusListener,
PropertyChangeListener,
InitValueSupport {
    private static final long serialVersionUID = 6438147255141035799L;
    private static final Font defaultFont = Font.decode("Arial 3");
    protected boolean editable = false;
    protected String value = "";
    protected transient ActionListener actionListener = null;
    private boolean doResize = false;
    protected Font font = null;
    protected Color color = null;

    public String toString() {
        return super.toString() + "[editable=" + this.editable + ", value=" + this.value + "]";
    }

    @Override
    public void init() {
        this.component = new TextField();
        ((JTextField)this.component).setEditable(this.editable);
        ((JTextField)this.component).setEnabled(this.editable);
        ((JTextField)this.component).addActionListener(this);
        ((JTextField)this.component).addFocusListener(this);
        this.setVisible(false);
        super.init();
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean value) {
        this.editable = value;
        if (this.component != null) {
            ((JTextField)this.component).setEditable(value);
            ((JTextField)this.component).setEnabled(value);
        }
    }

    @INode.SyncField(value={"value"})
    public void setText(String value) {
        this.value = value;
        if (value == null) {
            this.setVisible(false);
            return;
        }
        this.setVisible(true);
        if (this.component != null) {
            ((JTextField)this.component).setText(value);
            this.doResize = true;
        }
    }

    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
            this.doResize = true;
        }
    }

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((JTextField)this.component).setForeground(color);
            this.doResize = true;
        }
    }

    @Override
    public void render(Graphics2D g2d) {
        if (this.doResize) {
            this.doResize = false;
            this.recalculateSize(g2d);
        }
        ((JTextField)this.component).setScrollOffset(0);
        super.render(g2d);
    }

    private void recalculateSize(Graphics2D g2d) {
        if (this.component == null || this.value == null) {
            return;
        }
        Font font = ((JTextField)this.component).getFont();
        if (font != null) {
            FontMetrics metrics = ((JTextField)this.component).getFontMetrics(font);
            Rectangle2D size = metrics.getStringBounds(this.value, g2d);
            int xPadding = 0;
            int yPadding = 0;
            this.setBounds(new Rectangle2D.Double(0.0, 0.0, xPadding + (int)Math.ceil(size.getWidth()), yPadding + (int)Math.ceil(size.getHeight())));
            ((JTextField)this.component).setScrollOffset(0);
        }
    }

    public String getText() {
        return this.value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName()) && this.component != null) {
            ((JTextField)this.component).setText((String)evt.getNewValue());
            this.doResize = true;
        } else if ("editable".equals(evt.getPropertyName()) && this.component != null) {
            ((JTextField)this.component).setEditable((Boolean)evt.getNewValue());
            ((JTextField)this.component).setEnabled((Boolean)evt.getNewValue());
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.container.getParent() != null) {
            this.container.getParent().requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        ActionEvent e = new ActionEvent(this.component, 1001, ((TextField)this.component).getText());
        this.performAction(e);
    }

    @INode.ServerSide
    public void performAction(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    public void setValue(String key, Object value) {
        if ("text".equals(key)) {
            if (value instanceof String) {
                this.setText((String)value);
            } else {
                String error = "monitornode expects a string as 'text' (got " + (value != null ? value.getClass().getName() : "null") + ").";
                System.out.println(error);
                this.setText(error);
            }
        }
        if ("font".equals(key)) {
            this.setFont(Font.decode((String)value));
        }
    }

    public void initValues() {
        this.setText(null);
        this.setFont(defaultFont);
    }

    static class TextField
    extends JTextField {
        private static final long serialVersionUID = -668522226693100386L;

        TextField() {
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(null);
        }

        public void setBorder(double borderWidth) {
            super.setBorder(null);
        }
    }
}

