/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;
import org.simantics.scenegraph.utils.DummyComponent;

public class ListBoxNode
extends ComponentNode<JScrollPane>
implements FocusListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = 7073028693751719102L;
    protected boolean editable = true;
    protected Object value = "";
    protected String tooltip = "";
    protected double borderWidth = 0.0;
    protected transient ActionListener actionListener = null;
    protected Font font = null;
    protected Color color = null;
    protected List<String> items = null;
    protected transient JList list = null;

    public String toString() {
        return super.toString() + "[editable=" + this.editable + ", value=" + String.valueOf(this.value) + "]";
    }

    @Override
    public void init() {
        this.list = new JList(new DefaultListModel());
        this.component = new JScrollPane(this.list);
        this.list.setEnabled(this.editable);
        ((JScrollPane)this.component).setEnabled(this.editable);
        this.list.addFocusListener(this);
        this.list.addKeyListener(this);
        this.list.setLocation(0, 0);
        super.init();
    }

    @INode.SyncField(value={"items"})
    public void setItems(List<String> items) {
        this.items = items;
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        model.clear();
        for (String item : items) {
            model.addElement(item);
        }
        if (items.size() > 0) {
            this.list.setSelectedValue(items.get(0), true);
        }
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean value) {
        this.editable = value;
        if (this.component != null) {
            ((JScrollPane)this.component).setEnabled(value);
        }
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"borderWidth"})
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth.floatValue();
    }

    @INode.SyncField(value={"value"})
    public void setValue(Object value) {
        this.value = value;
        if (this.component != null && value != null) {
            this.list.setSelectedValue(value, true);
            ((JScrollPane)this.component).repaint();
        }
    }

    @INode.SyncField(value={"tooltip"})
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        if (this.component != null) {
            ((JScrollPane)this.component).setToolTipText(tooltip);
        }
    }

    @INode.PropertySetter(value="Font")
    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
        }
    }

    @INode.PropertySetter(value="Color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((JScrollPane)this.component).setForeground(color);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("value".equals(evt.getPropertyName()) && this.component != null) {
            this.list.setSelectedValue(evt.getNewValue(), true);
            ((JScrollPane)this.component).repaint();
        } else if ("editable".equals(evt.getPropertyName()) && this.component != null) {
            ((JScrollPane)this.component).setEnabled((Boolean)evt.getNewValue());
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    void loseFocus() {
        if (this.component != null && ((JScrollPane)this.component).isFocusOwner() && this.container.getParent() != null) {
            this.container.getParent().requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        if (this.component != null) {
            ActionEvent e = new ActionEvent(this.component, 1001, (String)this.list.getSelectedValue());
            this.performAction(e);
        }
    }

    @INode.ServerSide
    public void performAction(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getModifiers() == 0 && e.getKeyCode() == 27) {
            this.loseFocus();
        }
    }

    public void input(String input) {
        ActionEvent e = new ActionEvent(new DummyComponent(), 1001, input);
        this.performAction(e);
    }
}

