/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.modules;

import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

public class ModuleComponentTypeNode
extends AbstractNode<Resource>
implements IDeletableNode,
IModifiableNode {
    Listener<String> configurationNameSynchronizer;
    private boolean disposed = false;
    private Resource configuration;

    public ModuleComponentTypeNode(Resource resource) {
        super((Object)resource);
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)graph);
                ModuleComponentTypeNode.this.configuration = graph.getPossibleObject((Resource)ModuleComponentTypeNode.this.data, sr2.IsDefinedBy);
            }
        });
        this.configurationNameSynchronizer = new Listener<String>(){

            public void execute(final String result) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        if ((this).ModuleComponentTypeNode.this.configuration != null) {
                            graph.claimLiteral((this).ModuleComponentTypeNode.this.configuration, Layer0.getInstance((ReadGraph)graph).HasLabel, (Object)result);
                        }
                    }
                });
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return ModuleComponentTypeNode.this.disposed;
            }
        };
        Simantics.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                return (String)graph.getRelatedValue((Resource)ModuleComponentTypeNode.this.data, l0.HasName);
            }
        }, this.configurationNameSynchronizer);
    }

    public Labeler.Modifier getModifier(String columnId) {
        Labeler.Modifier modifier = null;
        try {
            modifier = (Labeler.Modifier)Simantics.getSession().syncRequest((Read)new Read<Labeler.Modifier>(){

                public Labeler.Modifier perform(ReadGraph graph) throws ManyObjectsForFunctionalRelationException, ServiceException {
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource type = graph.getPossibleObject((Resource)ModuleComponentTypeNode.this.data, mr.SymbolToComponentType);
                    LabelModifier modifier = new LabelModifier(Simantics.getSession(), type, l0.HasName){

                        public String isValid(String label) {
                            if (label.isEmpty()) {
                                return "Empty name not allowed";
                            }
                            return null;
                        }
                    };
                    return modifier;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return modifier;
    }

    public void delete() throws DeleteException {
        this.disposed = true;
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    StructuralResource2 st = StructuralResource2.getInstance((ReadGraph)graph);
                    ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
                    Resource type = graph.getPossibleObject((Resource)ModuleComponentTypeNode.this.data, mr.SymbolToComponentType);
                    Resource model = graph.getSingleObject(type, l0.PartOf);
                    Resource modelConfiguration = graph.getSingleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                    if (!((Collection)graph.syncRequest((Read)new ObjectsWithType(modelConfiguration, l0.ConsistsOf, type))).isEmpty()) {
                        System.out.println("The module is used at the model configuration");
                        return;
                    }
                    Collection moduleTypes = (Collection)graph.syncRequest((Read)new ObjectsWithType(model, l0.ConsistsOf, st.ComponentType));
                    for (Resource r : moduleTypes) {
                        Resource configuration = graph.getSingleObject(r, st.IsDefinedBy);
                        if (((Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, l0.ConsistsOf, type))).isEmpty()) continue;
                        System.out.println("The module is used at another module: " + String.valueOf(graph.getRelatedValue(r, l0.HasName)));
                        return;
                    }
                    graph.deny(model, l0.ConsistsOf, type);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (PasteHandler.class == adapter && this.configuration != null) {
            return (T)new DefaultPasteHandler(this.configuration);
        }
        return (T)super.getAdapter(adapter);
    }
}

