/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.ISelectionUtils;

public class HistoryDataTab
extends LabelPropertyTabContributor {
    public HistoryDataTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        ScrolledComposite sc = new ScrolledComposite(body, 768);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sc);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)sc);
        Composite composite = new Composite((Composite)sc, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(3, 3).applyTo(composite);
        Label label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Name: ");
        TrackedText nameText = new TrackedText(composite, support, 2048);
        nameText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel"));
        nameText.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)nameText.getWidget());
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Sheet: ");
        TrackedCombo sheet = new TrackedCombo(composite, support, 2060);
        sheet.setItemFactory((ReadFactory)new SheetItemFactory());
        sheet.setSelectionFactory((ReadFactory)new SheetSelectionFactory());
        sheet.addModifyListener((TextModifyListener)new SheetModifyListener());
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)sheet.getWidget());
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Orientation: ");
        Composite orientation = new Composite(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)orientation);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(orientation);
        Button columns = new Button(orientation, support, 16);
        GridDataFactory.fillDefaults().applyTo((Control)columns.getWidget());
        columns.setText("Columns");
        columns.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_columns, (Object)Boolean.TRUE, (Binding)Bindings.BOOLEAN);
            }
        });
        columns.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, Boolean>(){

            public Boolean perform(ReadGraph graph, Resource input) throws DatabaseException {
                return (Boolean)graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_columns);
            }
        });
        Button rows = new Button(orientation, support, 16);
        rows.setText("Rows");
        rows.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                graph.claimLiteral(input, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_columns, (Object)Boolean.FALSE, (Binding)Bindings.BOOLEAN);
            }
        });
        rows.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, Boolean>(){

            public Boolean perform(ReadGraph graph, Resource input) throws DatabaseException {
                return Boolean.FALSE.equals(graph.getPossibleRelatedValue(input, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_columns));
            }
        });
        Group c = new Group(composite, 0);
        c.setText("Variables in range");
        GridDataFactory.fillDefaults().span(1, 4).applyTo((Control)c);
        GridLayoutFactory.fillDefaults().margins(3, 1).spacing(0, 0).applyTo((Composite)c);
        GraphExplorerComposite explorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, (Composite)c, support, 67584);
        explorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/HistoryDataset/HistoryDatasetVariablesBrowseContext"});
        explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        explorer.finish();
        GridDataFactory.fillDefaults().hint(-1, 100).grab(true, false).applyTo((Control)explorer);
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Range Start: ");
        TrackedText start = new TrackedText(composite, support, 2048);
        start.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/HistoryDataset/start"));
        start.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HistoryDataset/start"));
        GridDataFactory.fillDefaults().applyTo((Control)start.getWidget());
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Range End: ");
        TrackedText end = new TrackedText(composite, support, 2048);
        end.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/HistoryDataset/end"));
        end.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HistoryDataset/end"));
        GridDataFactory.fillDefaults().applyTo((Control)end.getWidget());
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 4).applyTo((Control)label);
        label.setText("Time variable: ");
        TrackedText time = new TrackedText(composite, support, 2048);
        time.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/HistoryDataset/timeName"));
        time.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/HistoryDataset/timeName"));
        GridDataFactory.fillDefaults().applyTo((Control)time.getWidget());
        sc.setContent((Control)composite);
        sc.setMinSize(composite.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
    }

    private class SheetItemFactory
    extends ReadFactoryImpl<Resource, Map<String, Object>> {
        private SheetItemFactory() {
        }

        public Map<String, Object> perform(ReadGraph graph, Resource historyData) throws DatabaseException {
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SimulationResource simu = SimulationResource.getInstance((ReadGraph)graph);
            SpreadsheetResource spreadSheet = SpreadsheetResource.getInstance((ReadGraph)graph);
            Resource model = graph.getPossibleObject(historyData, l0.PartOf);
            Resource config = graph.getPossibleObject(model, simu.HasConfiguration);
            Resource book = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(config, l0.ConsistsOf, spreadSheet.Book));
            Collection sheets = (Collection)graph.syncRequest((Read)new ObjectsWithType(book, l0.ConsistsOf, spreadSheet.Spreadsheet));
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Resource sheet : sheets) {
                map.put(NameUtils.getSafeName((ReadGraph)graph, (Resource)sheet), sheet);
            }
            return map;
        }
    }

    private class SheetModifyListener
    implements TextModifyListener,
    Widget {
        private ISessionContext context;
        private Object lastInput = null;

        private SheetModifyListener() {
        }

        public void modifyText(TrackedModifyEvent e) {
            Combo combo = (Combo)e.getWidget();
            String textValue = combo.getText();
            Map data = (Map)combo.getData();
            if (data == null) {
                return;
            }
            final Resource value = (Resource)data.get(textValue);
            if (value == null) {
                return;
            }
            final Object input = this.lastInput;
            try {
                this.context.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Resource resource = (Resource)ISelectionUtils.filterSingleSelection((Object)((ISelection)input), Resource.class);
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        graph.deny(resource, sr.HistoryDataset_sheet);
                        graph.claim(resource, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_sheet, value);
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void setInput(ISessionContext context, Object parameter) {
            this.context = context;
            this.lastInput = parameter;
        }
    }

    private class SheetSelectionFactory
    extends ReadFactoryImpl<Resource, String> {
        private SheetSelectionFactory() {
        }

        public String perform(ReadGraph graph, Resource historyData) throws DatabaseException {
            Resource selectedSheet = graph.getPossibleObject(historyData, SysdynResource.getInstance((ReadGraph)graph).HistoryDataset_sheet);
            if (selectedSheet != null) {
                String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)selectedSheet);
                return name;
            }
            return null;
        }
    }
}

