/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.actions.newActions;

import java.util.Map;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.db.request.Write;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.operation.Layer0X;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.datastructures.ArrayMap;

public class NewModuleTypeAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource model = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                        Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
                        ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
                        StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)g);
                        String name = NameUtils.findFreshName((ReadGraph)g, (String)"ModuleType", (Resource)model, (Resource)l0.ConsistsOf, (String)"%s%d");
                        Resource moduleType = g.newResource();
                        g.claimLiteral(moduleType, l0.HasName, (Object)name);
                        g.claim(moduleType, l0.Inherits, sr.Module);
                        g.claim(moduleType, l0.PartOf, model);
                        Resource configuration = GraphUtils.create2((WriteGraph)g, (Resource)sr.Configuration, (Object[])new Object[]{l0.HasName, name + "Configuration", l0.PartOf, moduleType});
                        g.claim(moduleType, sr2.IsDefinedBy, configuration);
                        Resource diagram = g.newResource();
                        ((Template)g.adapt(sr.ConfigurationDiagramTemplate, Template.class)).apply(g, (Map)ArrayMap.keys((Object[])new String[]{"", "diagram", "name"}).values(new Object[]{configuration, diagram, "Diagrammi"}));
                        for (Resource trigger : g.getObjects(diagram, L0X.HasTrigger)) {
                            if (!g.isInstanceOf(trigger, mr.DiagramToCompositeMapping)) continue;
                            g.deny(diagram, L0X.HasTrigger, trigger);
                        }
                        Resource mapping = g.newResource();
                        g.claim(mapping, l0.InstanceOf, null, sr.DiagramToCompositeMapping);
                        g.claim(diagram, L0X.HasTrigger, mapping);
                        Resource moduleSymbol = g.newResource();
                        g.claimLiteral(moduleSymbol, l0.HasName, (Object)(name + " Symbol"));
                        g.claimLiteral(moduleSymbol, l0.HasLabel, (Object)(name + " Symbol"));
                        g.claim(moduleSymbol, l0.Inherits, sr.ModuleSymbol);
                        g.claim(moduleSymbol, mr.SymbolToComponentType, moduleType);
                        g.claim(moduleSymbol, l0.PartOf, moduleType);
                        Resource terminal = g.newResource();
                        g.claim(terminal, l0.InstanceOf, sr.SysdynTerminal);
                        Resource relation = NewModuleTypeAction.createTerminalRelation(g, moduleSymbol, sr.IsHeadOfTerminal, sr.Variable_isHeadOf);
                        DiagramGraphUtil.addConnectionPoint((WriteGraph)g, (Resource)moduleSymbol, (Resource)terminal, (Resource)relation);
                        Resource terminal2 = g.newResource();
                        g.claim(terminal2, l0.InstanceOf, sr.SysdynTerminal);
                        relation = NewModuleTypeAction.createTerminalRelation(g, moduleSymbol, sr.IsTailOfTerminal, sr.Variable_isTailOf);
                        DiagramGraphUtil.addConnectionPoint((WriteGraph)g, (Resource)moduleSymbol, (Resource)terminal2, (Resource)relation);
                        g.claim(moduleSymbol, sr2.IsDefinedBy, OrderedSetUtils.create((WriteOnlyGraph)g, (Resource)sr2.Composite, (Resource[])new Resource[]{terminal, terminal2}));
                    }
                });
            }
        };
    }

    public static Resource createTerminalRelation(WriteGraph graph, Resource symbol, Resource connectionRelation, Resource configurationRelationBase) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource configurationRelationBaseInverse = graph.getSingleObject(configurationRelationBase, L0.InverseOf);
        Resource configurationRelation = GraphUtils.create((WriteGraph)graph, (Object[])new Object[]{L0.SubrelationOf, configurationRelationBase, L0.PartOf, symbol, L0.HasName, NameUtils.getSafeName((ReadGraph)graph, (Resource)configurationRelationBase)});
        Resource configurationRelationInverse = GraphUtils.create((WriteGraph)graph, (Object[])new Object[]{L0.PartOf, configurationRelation, L0.SubrelationOf, configurationRelationBaseInverse, L0.HasName, "Inverse", L0.InverseOf, configurationRelation});
        Resource terminalRelation = null;
        terminalRelation = GraphUtils.create((WriteGraph)graph, (Object[])new Object[]{MOD.DiagramConnectionRelationToConnectionRelation, configurationRelation, L0.PartOf, symbol, L0.HasName, NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation)});
        graph.claim(terminalRelation, L0.SubrelationOf, null, connectionRelation);
        Resource inverse = GraphUtils.create((WriteGraph)graph, (Object[])new Object[]{L0.PartOf, terminalRelation, L0.HasName, "Inverse"});
        graph.claim(inverse, L0.SubrelationOf, null, STR.Connects);
        graph.claim(terminalRelation, L0.InverseOf, inverse);
        return terminalRelation;
    }
}

