/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.IProject;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.handlers.SysdynExperimentActivator;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;

public class ActivateExperimentAction
implements IDoubleClickAction {
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        final Resource experiment = ResourceAdaptionUtils.toSingleResource((Object)e.getResource());
        if (experiment == null) {
            return;
        }
        if (g.isInstanceOf(experiment, SysdynResource.getInstance((ReadGraph)g).Experiment)) {
            final IProject project = Simantics.getProject();
            if (project == null) {
                return;
            }
            final IExperimentManager experimentManager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            if (experimentManager == null) {
                ErrorLogger.defaultLogWarning((String)"Experiment manager not available.", (Throwable)new Exception());
                return;
            }
            e.add((IPriorityAction)new PriorityAction(1020){

                public void run() {
                    SysdynExperimentActivator.scheduleActivation((RequestProcessor)Simantics.getSession(), project, experimentManager, experiment);
                }
            });
            e.consume();
        }
    }
}

