/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.ui;

import java.awt.geom.AffineTransform;
import java.util.function.Consumer;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.operation.Layer0X;
import org.simantics.scenegraph.INode;
import org.simantics.spreadsheet.graph.GraphUI;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.ui.SheetClass;
import org.simantics.spreadsheet.ui.SheetNode;

public class SheetFactory
implements ElementFactory {
    public static ElementClass createSheetClass(Resource elementType) {
        return SheetClass.INSTANCE.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)elementType)});
    }

    public void getClass(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource resource, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)SheetFactory.createSheetClass(((SpreadsheetResource)graph.getSession().getService(SpreadsheetResource.class)).Spreadsheet));
    }

    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)SheetFactory.createSheetClass(((SpreadsheetResource)graph.getSession().getService(SpreadsheetResource.class)).Spreadsheet));
    }

    public void load(AsyncReadGraph graph, ICanvasContext canvas, final IDiagram diagram, final Resource resource, final IElement element, final AsyncProcedure<IElement> procedure) {
        final SpreadsheetResource sr = (SpreadsheetResource)graph.getService(SpreadsheetResource.class);
        AffineTransform at = new AffineTransform();
        ElementUtils.setTransform((IElement)element, (AffineTransform)at);
        System.out.println("SheetFactory loads sheet at " + String.valueOf(resource));
        graph.forPossibleObject(resource, sr.HasSheet, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(final AsyncReadGraph g, final Resource sheet) {
                if (sheet != null) {
                    g.asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                            Session session = graph.getSession();
                            AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)resource);
                            ElementUtils.setTransform((IElement)element, (AffineTransform)at);
                            final GraphUI ui = new GraphUI((RequestProcessor)session);
                            String rvi = (String)graph.getPossibleRelatedValue(resource, sr.HasRVI);
                            System.out.println("SheetFactory loads rvi = " + rvi);
                            Resource model = graph.getResource((String)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_MODEL_URI));
                            Resource realization = graph.getPossibleObject(model, L0X.HasBaseRealization);
                            Variable base = (Variable)graph.adapt(realization, Variable.class);
                            System.out.println("SheetFactory loads base = " + base.getURI(graph));
                            final Variable sheetVariable = base.browse(graph, rvi);
                            element.setHint(SheetClass.KEY_SHEET, (Object)sheet);
                            element.setHint(SheetClass.KEY_RVI, (Object)rvi);
                            element.setHint(ElementHints.KEY_SG_CALLBACK, (Object)new Consumer<INode>(){

                                @Override
                                public void accept(INode _node) {
                                    SheetNode node = (SheetNode)_node;
                                    try {
                                        ui.load(sheetVariable, node.getModifier());
                                    }
                                    catch (DatabaseException e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                            procedure.execute(g, (Object)element);
                        }
                    });
                }
            }
        });
    }
}

