/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.loader;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.SceneGraphContext;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;

public class ScenegraphVariable
extends StandardGraphChildVariable {
    private final SceneGraphContext context;
    private final Map<String, Variant> originalProperties;
    private final Map<String, Variable> properties;

    public ScenegraphVariable(Variable parent, Resource resource, Resource runtime, INode root) {
        this(parent, resource, runtime, root, Collections.emptyMap());
    }

    public ScenegraphVariable(Variable parent, Resource resource, Resource runtime, INode root, Map<String, Variant> properties) {
        super(parent, null, resource);
        this.context = runtime != null ? new SceneGraphContextImpl(this, runtime, root) : null;
        this.originalProperties = properties;
        if (properties.isEmpty()) {
            this.properties = Collections.emptyMap();
        } else {
            this.properties = new THashMap();
            for (Map.Entry<String, Variant> p : properties.entrySet()) {
                this.properties.put(p.getKey(), (Variable)new ConstantPropertyVariable(parent, p.getKey(), p.getValue().getValue(), p.getValue().getBinding()));
            }
        }
    }

    public String getName(ReadGraph graph) throws DatabaseException {
        if (this.parent instanceof ScenegraphVariable) {
            return super.getName(graph);
        }
        return "" + System.identityHashCode((Object)this);
    }

    public Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        if (this.parent instanceof ScenegraphVariable) {
            return super.getNameVariable(graph);
        }
        return new ConstantPropertyVariable(this.parent, "HasName", (Object)("" + System.identityHashCode((Object)this)), (Binding)Bindings.STRING);
    }

    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (SceneGraphContext.class == clazz) {
            return (T)this.context;
        }
        if (INode.class == clazz) {
            return (T)this.context.getRoot();
        }
        return null;
    }

    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = this.tryAdapt(graph, clazz);
        return (T)(t != null ? t : super.adapt(graph, clazz));
    }

    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = this.tryAdapt(graph, clazz);
        return (T)(t != null ? t : super.adaptPossible(graph, clazz));
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ScenegraphVariable other = (ScenegraphVariable)((Object)obj);
        SceneGraphContext otherContext = other.context;
        return ObjectUtils.objectEquals((Object)this.context, (Object)otherContext);
    }

    public int hashCode() {
        int s = super.hashCode();
        if (this.context != null) {
            s ^= this.context.getRuntime().hashCode();
        }
        return s;
    }

    public Collection<Variable> getChildren(ReadGraph graph) throws DatabaseException {
        return ScenegraphLoaderUtils.computeChildren(graph, (Variable)this);
    }

    public Variable getPossibleChild(ReadGraph graph, String name) throws DatabaseException {
        for (Variable child : this.getChildren(graph)) {
            if (!child.getName(graph).equals(name)) continue;
            return child;
        }
        return null;
    }

    public void collectExtraProperties(ReadGraph graph, Map<String, Variable> properties) throws DatabaseException {
        properties.putAll(this.properties);
    }

    public Variable getPossibleExtraProperty(ReadGraph graph, String name) throws DatabaseException {
        return this.properties.get(name);
    }

    public static class SceneGraphContextImpl
    implements SceneGraphContext {
        private final ScenegraphVariable parent;
        private final Resource runtime;
        private final INode root;

        public SceneGraphContextImpl(ScenegraphVariable parent, Resource runtime, INode root) {
            assert (root != null);
            this.parent = parent;
            this.runtime = runtime;
            this.root = root;
        }

        @Override
        public INode getRoot() {
            return this.root;
        }

        @Override
        public Resource getRuntime() {
            return this.runtime;
        }

        @Override
        public Variable getRuntimeVariable() {
            return new ScenegraphVariable((Variable)this.parent, this.runtime, this.runtime, this.root, this.parent.originalProperties);
        }

        public int hashCode() {
            return this.runtime.hashCode() ^ Objects.hashCode(this.root);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            SceneGraphContextImpl other = (SceneGraphContextImpl)obj;
            if (!this.runtime.equals(other.runtime)) {
                return false;
            }
            return ObjectUtils.objectEquals((Object)this.root, (Object)other.root);
        }
    }
}

