/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.swt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.document.server.IEventCommand;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.client.Document;
import org.simantics.document.server.client.DocumentClient;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.client.WidgetMapping;
import org.simantics.document.server.io.AbstractEventHandler;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.SWTViews;
import org.simantics.document.swt.core.base.WidgetContainer;
import org.simantics.document.swt.core.widget.FillComposite;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWTDocumentClient
extends DocumentClient
implements SWTDocument {
    static final Logger LOGGER = LoggerFactory.getLogger(SWTDocumentClient.class);
    private Composite container;
    private IWorkbenchSite site;
    private ISelectionProvider selectionProvider;
    private Device device;
    private IThreadWorkQueue thread;
    private Map<RGB.Integer, Color> colors = new HashMap<RGB.Integer, Color>();
    private Map<Font, org.eclipse.swt.graphics.Font> fonts = new HashMap<Font, org.eclipse.swt.graphics.Font>();
    private boolean requireLayout = false;

    public SWTDocumentClient(WidgetMapping mapping, ISelectionProvider selectionProvider, IWorkbenchSite site, Composite container) {
        super(mapping, SWTViews.getCommandMapping());
        this.container = container;
        this.site = site;
        this.selectionProvider = selectionProvider;
        this.device = container.getDisplay();
        this.thread = SWTThread.getThreadAccess((Widget)container);
        JSONObject rootObject = new JSONObject("root", "type", (Object)"Root");
        FillComposite mgr = new FillComposite();
        WidgetContainer wc = mgr.createWidget(rootObject);
        wc.createControl(this, container, rootObject);
        GridDataFactory.fillDefaults().grab(true, true).minSize(1, 1).applyTo(wc.getControl());
        GridLayoutFactory.fillDefaults().applyTo((Composite)wc.getControl());
        this.widgetData.put("root", new WidgetData((Document)this, (Object)wc, rootObject));
    }

    public IThreadWorkQueue thread() {
        return this.thread;
    }

    @Override
    public Color getColor(RGB.Integer descriptor) {
        Color color = this.colors.get(descriptor);
        if (color == null) {
            color = Colors.swt((Device)this.device, (RGB.Integer)descriptor);
            this.colors.put(descriptor, color);
        }
        return color;
    }

    @Override
    public org.eclipse.swt.graphics.Font getFont(Font descriptor) {
        org.eclipse.swt.graphics.Font font = this.fonts.get(descriptor);
        if (font == null) {
            font = Fonts.swt((Device)this.device, (Font)descriptor);
            this.fonts.put(descriptor, font);
        }
        return font;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public IWorkbenchSite getSite() {
        return this.site;
    }

    @Override
    public void post(AbstractEventHandler handler, CommandContextMutable parameters) {
        handler.handle((CommandContext)parameters);
    }

    protected void updateDocument(Collection<JSONObject> objects) {
        assert (this.thread.currentThreadAccess());
        super.updateDocument(objects);
        if (this.requireLayout) {
            this.container.layout(true, true);
            this.requireLayout = false;
        }
    }

    protected void updateTree(HashSet<WidgetData> updates) {
        WidgetContainer container;
        if (updates.isEmpty()) {
            return;
        }
        for (WidgetData data : updates) {
            container = (WidgetContainer)data.widget;
            Object ctrl = container.getControl();
            if (ctrl == null || ctrl.isDisposed() || !(ctrl instanceof Composite)) continue;
            Composite composite = (Composite)ctrl;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
        super.updateTree(updates);
        for (WidgetData data : this.widgetData.values()) {
            container = (WidgetContainer)data.widget;
            if (container == null) continue;
            container.getOrCreateControl(this, data.object);
        }
    }

    @Override
    public CommandContext handleCommands(List<Pair<WidgetData, ICommand>> data, CommandContextMutable context, Object component) {
        ArrayList<IEventCommand> commands = new ArrayList<IEventCommand>();
        for (Pair<WidgetData, ICommand> pair : data) {
            WidgetData d = (WidgetData)pair.first;
            ICommand c = (ICommand)pair.second;
            IEventCommand p = d.eventCommand(c, null);
            if (p == null) continue;
            if (!commands.isEmpty()) {
                ((IEventCommand)commands.get(commands.size() - 1)).setNext(p);
            }
            commands.add(p);
        }
        if (!commands.isEmpty()) {
            ((IEventCommand)commands.get(0)).handleCommand(context);
        }
        return context;
    }

    @Override
    public void layout() {
        this.requireLayout = true;
    }

    public HashMap<String, WidgetData> getWidgetData() {
        return this.widgetData;
    }

    @Override
    public void displayError(String error) {
        LOGGER.error(error);
    }
}

