/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.example;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Heartbeat;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.FixedSize;
import org.simantics.g2d.element.handler.impl.TextColorImpl;
import org.simantics.g2d.element.handler.impl.TextPainter;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.FilmClass;

public class LoadingMessageDiagram {
    public static final ElementClass LOADING_CLASS = ElementClass.compile(TextColorImpl.WHITE, DefaultTransform.INSTANCE, FixedSize.of(30.0, 20.0), Text.INSTANCE, new TextPainter(), new LoadingAnimation());
    public static final IDiagram LOADING_DIAGRAM = LoadingMessageDiagram.createLoadingDiagram();

    public static IDiagram createLoadingDiagram() {
        String name = "Loading...";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement film = Element.spawnNew(FilmClass.FILM_CLASS);
        ElementUtils.fitToRectangle(film, new Rectangle2D.Double(0.0, 4.0, 40.0, 30.0));
        d.addElement(film);
        ElementUtils.setFillColor(film, new Color(0.3f, 0.3f, 0.8f, 0.5f));
        IElement lbl = Element.spawnNew(LOADING_CLASS);
        d.addElement(lbl);
        ElementUtils.setPos(lbl, 5.0, 7.0);
        ElementUtils.setText(lbl, "Loading");
        ElementUtils.setTextColor(lbl, Color.WHITE);
        return d;
    }

    private static class LoadingAnimation
    implements Heartbeat {
        private static final long serialVersionUID = 2721735864087380222L;

        private LoadingAnimation() {
        }

        @Override
        public void heartbeat(IElement e, long time, long deltaTime, ICanvasContext ctx) {
            int dotCount = (int)(time % 1000L / 200L);
            Object dots = "";
            int i = 0;
            while (i < dotCount) {
                dots = (String)dots + ".";
                ++i;
            }
            ElementUtils.setText(e, "Loading" + (String)dots);
            ctx.getContentContext().setDirty();
        }
    }
}

