/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.impl;

import java.util.Map;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementAdapter;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;

public class Element
extends HintContext
implements IElement {
    private ElementClass clazz;
    private IDiagram diagram;

    public static IElement clone(IElement cloneFrom) {
        Element e = new Element(cloneFrom.getElementClass());
        e.setHints(cloneFrom.getHints());
        return e;
    }

    public static IElement spawnNew(ElementClass clazz) {
        assert (clazz != null);
        Element e = new Element(clazz);
        Element.fireCreated(e);
        return e;
    }

    public static IElement instantiate(ElementClass clazz, Map<IHintContext.Key, Object> oldValues) {
        Element e = new Element(clazz);
        if (oldValues != null) {
            e.setHints(oldValues);
        }
        return e;
    }

    public Element(ElementClass clazz) {
        assert (clazz != null);
        this.clazz = clazz;
    }

    @Override
    public IDiagram getDiagram() {
        assert (this.diagram != null);
        return this.diagram;
    }

    @Override
    public IDiagram peekDiagram() {
        return this.diagram;
    }

    @Override
    public ElementClass getElementClass() {
        return this.clazz;
    }

    public void setElementClass(ElementClass newClass) {
        if (newClass == null) {
            throw new IllegalArgumentException("null element class");
        }
        this.clazz = newClass;
    }

    public String toString() {
        String clazzId;
        Object dada;
        String text = (String)this.getHint(ElementHints.KEY_TEXT);
        if (text == null) {
            text = "";
        }
        if ((dada = this.getHint(ElementHints.KEY_OBJECT)) == null) {
            dada = "";
        }
        String clazzStr = (clazzId = this.clazz.getId()) != null && !clazzId.isEmpty() ? clazzId : this.clazz.getClass().getSimpleName() + "@" + this.clazz.hashCode();
        return clazzStr + "[" + super.toString() + " " + text + " " + String.valueOf(dada) + "]";
    }

    @Override
    public void addedToDiagram(IDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public void destroy() {
        Element.fireDestroyed(this);
    }

    public static void fireDestroyed(IElement e) {
        for (LifeCycle lc : e.getElementClass().getItemsByClass(LifeCycle.class)) {
            lc.onElementDestroyed(e);
        }
    }

    public static void fireCreated(IElement e) {
        for (LifeCycle lc : e.getElementClass().getItemsByClass(LifeCycle.class)) {
            lc.onElementCreated(e);
        }
    }

    @Override
    public void dispose() {
        this.clearWithoutNotification();
    }

    public <T> T adapt(Class<T> adapter) {
        for (ElementAdapter ea : this.clazz.getItemsByClass(ElementAdapter.class)) {
            T result = ea.adapt(this, adapter);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

