/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search.impl;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.editors.BrowserInput;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function5;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.simantics.workbench.ontology.WorkbenchResource;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.QueryResult;
import org.simantics.workbench.search.SearchEngine;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;
import org.simantics.workbench.search.Searching;
import org.simantics.workbench.search.impl.Activator;
import org.simantics.workbench.search.impl.BrowserView;

public class SearchServiceImpl
implements ISearchService {
    private static final String SEARCH_TEMP_FILE_SUFFIX = "search.html";
    private static final String SEARCH_TEMP_DIR = "search";
    private static final String BROWSER_VIEW = "org.simantics.workbench.search.browser";
    private static final Integer MAX_RESULTS = 1000;
    BrowserView browserView = null;
    Browser browserViewBrowser = null;
    List<File> browserViewTemporaryFiles = null;
    LocationListener browserViewLocationListener = new LocationListener(){

        public void changing(LocationEvent event) {
            try {
                URI newUri = new URI(event.location);
                if ("resource".equals(newUri.getScheme())) {
                    event.doit = false;
                    SearchServiceImpl.this.openResource(SearchServiceImpl.this.getShell(event), newUri.getSchemeSpecificPart());
                    return;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }

        public void changed(LocationEvent event) {
            try {
                SearchQuery searchQuery;
                URL newUrl = new URL(event.location);
                String query = newUrl.getQuery();
                if (query != null && (searchQuery = SearchQuery.decode((URL)newUrl)).getOriginalQuery() != null) {
                    event.doit = SearchServiceImpl.this.updateViewQuery(SearchServiceImpl.this.browserView, SearchServiceImpl.this.browserViewTemporaryFiles, searchQuery);
                }
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
    };

    public void performQuery(SearchQuery query, ISearchService.ResultBrowser browserType, boolean activateResultBrowser) {
        try {
            Set<SearchEngine> searchEngines = SearchServiceImpl.getSearchEngines();
            boolean containsEngines = false;
            for (SearchEngine e : searchEngines) {
                if (!query.getSearchFlags().containsKey(e.getId())) continue;
                containsEngines = true;
                break;
            }
            if (!containsEngines) {
                for (SearchEngine e : searchEngines) {
                    if (!e.isEnabledByDefault()) continue;
                    query.setSearchFlag(e.getId(), "on");
                }
            }
        }
        catch (DatabaseException e) {
            ExceptionUtils.logError((Throwable)e);
        }
        switch (browserType) {
            case EDITOR: {
                this.performEditorQuery(query);
                break;
            }
            case VIEW: {
                this.performViewQuery(query, activateResultBrowser);
            }
        }
    }

    private void performViewQuery(SearchQuery query, boolean activateResultBrowser) {
        try {
            this.browserView = (BrowserView)this.showLocalView(BROWSER_VIEW, activateResultBrowser ? 1 : 3);
            if (this.browserView.getBrowser() != this.browserViewBrowser) {
                this.browserViewBrowser = this.browserView.getBrowser();
                this.browserViewTemporaryFiles = new ArrayList<File>();
                this.browserViewTemporaryFiles.add(SearchServiceImpl.getNewTemporaryFile());
                this.browserView.getBrowser().addLocationListener(this.browserViewLocationListener);
                this.browserView.getBrowser().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        SearchServiceImpl.this.browserViewBrowser = null;
                    }
                });
            }
            this.browserView.setPartProperty("org.simantics.workbench.search.browser.lastQuery", query.getOriginalQuery());
            this.updateViewQuery(this.browserView, this.browserViewTemporaryFiles, query);
        }
        catch (IOException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        catch (PartInitException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
    }

    private IViewPart showLocalView(String id, int mode) throws PartInitException {
        IWorkbenchWindow wb = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (wb == null) {
            return null;
        }
        IViewPart vp = SearchServiceImpl.findViewFromWindow(wb, id, false);
        if (vp != null) {
            if (mode == 3) {
                return vp;
            }
            IWorkbenchPage page = vp.getViewSite().getPage();
            if (mode == 2) {
                page.bringToTop((IWorkbenchPart)vp);
            } else if (mode == 1) {
                page.activate((IWorkbenchPart)vp);
            }
            return vp;
        }
        IWorkbenchPage page = wb.getActivePage();
        if (page == null) {
            IWorkbenchPage[] pages = wb.getPages();
            if (pages.length == 0) {
                return null;
            }
            page = pages[0];
        }
        return page.showView(id, null, mode);
    }

    private static IViewPart findViewFromWindow(IWorkbenchWindow wb, String viewId, boolean restore) {
        IWorkbenchPage[] iWorkbenchPageArray = wb.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart vp;
            IWorkbenchPage page = iWorkbenchPageArray[n2];
            IViewReference vr = page.findViewReference(viewId);
            if (vr != null && (vp = vr.getView(restore)) != null) {
                return vp;
            }
            ++n2;
        }
        return null;
    }

    protected boolean updateViewQuery(BrowserView browserView, List<File> temporaryFiles, SearchQuery query) {
        ViewQueryJob job = new ViewQueryJob(query, temporaryFiles, browserView);
        job.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)browserView));
        job.schedule();
        return true;
    }

    protected Shell getShell(LocationEvent event) {
        if (event.widget instanceof Control) {
            Control c = (Control)event.widget;
            if (c.isDisposed()) {
                return null;
            }
            return c.getShell();
        }
        return null;
    }

    protected void performEditorQuery(final SearchQuery query) {
        try {
            final ArrayList<File> temporaryFiles = new ArrayList<File>();
            temporaryFiles.add(SearchServiceImpl.getNewTemporaryFile());
            final BrowserInput input = SearchServiceImpl.createBrowserInput((File)temporaryFiles.get(0), query);
            SearchServiceImpl.updateInput(input, (File)temporaryFiles.get(0), query);
            final org.simantics.editors.Browser browser = (org.simantics.editors.Browser)WorkbenchUtils.openEditor((String)"org.simantics.editors.browser", (IEditorInput)input);
            browser.getBrowser().addLocationListener(new LocationListener(){

                public void changing(LocationEvent event) {
                    try {
                        URI newUri = new URI(event.location.replaceAll(" ", "%20"));
                        if ("resource".equals(newUri.getScheme())) {
                            event.doit = false;
                            SearchServiceImpl.this.openResource(SearchServiceImpl.this.getShell(event), newUri.getSchemeSpecificPart());
                            return;
                        }
                    }
                    catch (URISyntaxException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }

                public void changed(LocationEvent event) {
                    SearchQuery searchQuery;
                    if (query != null && (searchQuery = query).getOriginalQuery() != null) {
                        event.doit = SearchServiceImpl.updateQuery(browser, input, temporaryFiles, searchQuery);
                    }
                }
            });
        }
        catch (IOException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        catch (PartInitException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
    }

    protected void openResource(Shell shell, String link) throws DatabaseException {
        try {
            Session session = Simantics.getSession();
            final long id = Long.parseLong(link);
            Resource resource = (Resource)session.syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
                    return ss.getResource(id);
                }
            });
            StructuredSelection input = new StructuredSelection((Object)resource);
            String perspectiveId = WorkbenchUtils.getCurrentPerspectiveId();
            session.asyncRequest((Read)new ChooseActionRequest(shell, (Object)input, perspectiveId, false, true));
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    protected static boolean updateQuery(org.simantics.editors.Browser browser, BrowserInput input, List<File> temporaryFiles, SearchQuery query) {
        block5: {
            String url = browser.getBrowser().getUrl();
            String inputUrl = input.getUrl().toString();
            if (!url.equals(inputUrl)) break block5;
            return false;
        }
        try {
            List<QueryResult> result = SearchServiceImpl.createResultPage((IProgressMonitor)new NullProgressMonitor(), query, MAX_RESULTS);
            SearchServiceImpl.updateInput(input, temporaryFiles.get(0), query);
            SearchServiceImpl.updatePages(result, temporaryFiles);
            browser.getBrowser().refresh();
            for (File temporaryFile : temporaryFiles) {
                temporaryFile.deleteOnExit();
            }
            return true;
        }
        catch (DatabaseException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        catch (IOException e1) {
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        return false;
    }

    private static File ensureTemporaryDirectoryExists() throws IOException {
        return Simantics.getTemporaryDirectory((String)SEARCH_TEMP_DIR);
    }

    private static File getNewTemporaryFile() throws IOException {
        return Simantics.getTempfile((String)SEARCH_TEMP_DIR, (String)SEARCH_TEMP_FILE_SUFFIX);
    }

    private static BrowserInput createBrowserInput(File file, SearchQuery query) throws IOException {
        return new BrowserInput(SearchQuery.encode((File)file, (SearchQuery)query), query.getOriginalQuery(), false, false, 0);
    }

    private static void updatePages(List<QueryResult> result, List<File> temporaryFiles) throws IOException {
        SearchServiceImpl.ensureTemporaryDirectoryExists();
        int i = temporaryFiles.size();
        while (i < result.size()) {
            temporaryFiles.add(SearchServiceImpl.getNewTemporaryFile());
            ++i;
        }
        if (result.size() > 1) {
            SearchServiceImpl.createPageControls(result, temporaryFiles);
        }
        if (result.size() > 0) {
            i = 0;
            while (i < result.size()) {
                SearchServiceImpl.updatePage(temporaryFiles.get(i), result.get(i).getHtml());
                ++i;
            }
        } else {
            SearchServiceImpl.updatePage(temporaryFiles.get(0), "");
        }
    }

    private static void updatePage(File file, String html) throws IOException {
        long t1 = System.currentTimeMillis();
        FileUtils.writeFile((File)file, (byte[])html.getBytes("UTF-8"));
        long t2 = System.currentTimeMillis();
        System.out.println("Writing html page took " + (t2 - t1) + " ms");
    }

    private static void createPageControls(List<QueryResult> result, List<File> temporaryFiles) throws IOException {
        if (result.size() == 1) {
            return;
        }
        int i = 0;
        while (i < result.size()) {
            boolean first = i == 0;
            boolean last = i == result.size() - 1;
            QueryResult current = result.get(i);
            Object pageContrtol = "<div class=\"resultInfo\">";
            pageContrtol = (String)pageContrtol + "Page " + (i + 1) + " of " + result.size() + " ";
            if (first) {
                pageContrtol = (String)pageContrtol + "First";
                pageContrtol = (String)pageContrtol + " Previous";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(i + 1).toURI().toURL().toString() + "\">Next</a>";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(result.size() - 1).toURI().toURL().toString() + "\">Last</a>";
            } else if (last) {
                pageContrtol = (String)pageContrtol + "<a href=\"" + temporaryFiles.get(0).toURI().toURL().toString() + "\">First</a>";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(i - 1).toURI().toURL().toString() + "\">Previous</a>";
                pageContrtol = (String)pageContrtol + " Next";
                pageContrtol = (String)pageContrtol + " Last";
            } else {
                pageContrtol = (String)pageContrtol + "<a href=\"" + temporaryFiles.get(0).toURI().toURL().toString() + "\">First</a>";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(i - 1).toURI().toURL().toString() + "\">Previous</a>";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(i + 1).toURI().toURL().toString() + "\">Next</a>";
                pageContrtol = (String)pageContrtol + " <a href=\"" + temporaryFiles.get(result.size() - 1).toURI().toURL().toString() + "\">Last</a>";
            }
            pageContrtol = (String)pageContrtol + "</div><br>";
            result.set(i, new QueryResult(current.getHeader(), (String)pageContrtol + current.getContent() + (String)pageContrtol, current.getFooter(), current.getHitCount()));
            ++i;
        }
    }

    private static void updateInput(BrowserInput input, File file, SearchQuery query) throws IOException {
        URL url = SearchQuery.encode((File)file, (SearchQuery)query);
        input.setUrl(url);
        input.setName(query.getOriginalQuery());
    }

    private static Set<SearchEngine> getSearchEngines() throws DatabaseException {
        return (Set)Simantics.getSession().syncRequest((Read)new Read<Set<SearchEngine>>(){

            public Set<SearchEngine> perform(ReadGraph graph) throws DatabaseException {
                Resource project = Simantics.peekProjectResource();
                if (project == null) {
                    return Collections.emptySet();
                }
                return SearchServiceImpl.getSearchEngines(graph, project);
            }
        });
    }

    private static Set<SearchEngine> getSearchEngines(ReadGraph graph, Resource project) throws DatabaseException {
        HashSet<SearchEngine> searchEngines = new HashSet<SearchEngine>();
        Map<Resource, Set<SearchEngine>> result = SearchServiceImpl.getSearchEnginesByModel(graph, project);
        for (Set<SearchEngine> set : result.values()) {
            searchEngines.addAll(set);
        }
        return searchEngines;
    }

    private static Map<Resource, Set<SearchEngine>> getSearchEnginesByModel(ReadGraph graph, Resource project) throws DatabaseException {
        WorkbenchResource WB = WorkbenchResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        HashMap<Resource, Set<SearchEngine>> result = new HashMap<Resource, Set<SearchEngine>>();
        Collection activeModels = (Collection)graph.syncRequest((Read)new ActiveModels(project));
        for (Resource model : activeModels) {
            HashSet<SearchEngine> searchEngines = new HashSet<SearchEngine>();
            ArrayList<Resource> searchFunctions = new ArrayList<Resource>();
            searchFunctions.addAll(graph.getObjects(model, WB.HasWorkbenchSearchFunction));
            if (searchFunctions.size() == 0) {
                searchEngines.addAll(SearchServiceImpl.findSearchContributions(graph, model));
            }
            if (searchFunctions.isEmpty() && searchEngines.isEmpty()) {
                searchFunctions.addAll(graph.getObjects(project, WB.HasWorkbenchSearchFunction));
            }
            if (searchFunctions.isEmpty() && searchEngines.isEmpty()) {
                searchFunctions.add(WB.DependenciesSearchFunction);
            }
            for (Resource searchFunction : searchFunctions) {
                Function f = (Function)graph.adapt(searchFunction, Function.class);
                String id = graph.getURI(searchFunction);
                String name = (String)graph.getPossibleRelatedValue2(searchFunction, L0.HasLabel);
                SearchEngine engine = new SearchEngine(id, name, (Function5)f, true);
                engine.addSupportedParam("NameSearch", "Name");
                engine.addSupportedParam("TypesSearch", "Types");
                searchEngines.add(engine);
            }
            result.put(model, searchEngines);
        }
        return result;
    }

    private static List<QueryResult> createResultPage(final IProgressMonitor monitor, final SearchQuery query, final int maxResults) throws DatabaseException {
        return (List)Simantics.getSession().syncRequest((Read)new Read<List<QueryResult>>(){

            public List<QueryResult> perform(ReadGraph graph) throws DatabaseException {
                Resource project = Simantics.peekProjectResource();
                if (project == null) {
                    return null;
                }
                Collection activeModels = (Collection)graph.syncRequest((Read)new ActiveModels(project));
                long t1 = System.currentTimeMillis();
                HashSet<SearchEngine> searchEngines = new HashSet<SearchEngine>();
                MapList searchResults = new MapList();
                Map<Resource, Set<SearchEngine>> searchEngineMap = SearchServiceImpl.getSearchEnginesByModel(graph, project);
                for (Resource model : activeModels) {
                    for (SearchEngine engine : searchEngineMap.get(model)) {
                        SearchResult result;
                        if (query.getBooleanFlag(engine.getId()) && !(result = (SearchResult)engine.getSearchFunction().apply((Object)monitor, (Object)graph, (Object)model, (Object)query, (Object)maxResults)).isEmpty()) {
                            searchResults.add((Object)model, (Object)new Pair((Object)engine, (Object)result));
                        }
                        searchEngines.add(engine);
                    }
                }
                long t2 = System.currentTimeMillis();
                System.out.println("Running search queries took " + (t2 - t1) + " ms for query '" + String.valueOf(query) + "'");
                try {
                    return Searching.generatePage((ReadGraph)graph, searchEngines, (SearchQuery)query, (int)maxResults, (MapList)searchResults);
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().error("I/O problem while generating search result page.", (Throwable)e);
                }
                catch (TemplateException e) {
                    Activator.getDefault().getLog().error("Template definition problem in search result page generation. Please inform the developers.", (Throwable)e);
                }
                return null;
            }
        });
    }

    private static Collection<SearchEngine> findSearchContributions(ReadGraph graph, Resource model) throws DatabaseException {
        WorkbenchResource WB = WorkbenchResource.getInstance((ReadGraph)graph);
        Instances contributionFinder = (Instances)graph.adapt(WB.SearchContribution, Instances.class);
        Resource index = model;
        ArrayList<SearchEngine> result = new ArrayList<SearchEngine>();
        for (Resource r : contributionFinder.find(graph, index)) {
            SearchEngine engine = SearchServiceImpl.contributionToEngine(graph, r);
            if (engine == null) continue;
            result.add(engine);
        }
        return result;
    }

    private static SearchEngine contributionToEngine(ReadGraph graph, Resource searchContribution) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        WorkbenchResource WB = WorkbenchResource.getInstance((ReadGraph)graph);
        Resource searchFunction = graph.getPossibleObject(searchContribution, WB.hasSearchFunction);
        if (searchFunction == null) {
            return null;
        }
        Function f = (Function)graph.adapt(searchFunction, Function.class);
        String id = graph.getURI(searchFunction);
        String name = (String)graph.getPossibleRelatedValue2(searchFunction, L0.HasLabel);
        Boolean enabledByDefault = (Boolean)graph.getPossibleRelatedValue2(searchContribution, WB.SearchContribution_isEnabledByDefault, (Binding)Bindings.BOOLEAN);
        boolean enabled = !Boolean.FALSE.equals(enabledByDefault);
        SearchEngine engine = new SearchEngine(id, name, (Function5)f, enabled);
        engine.addSupportedParam("NameSearch", "Name");
        engine.addSupportedParam("TypesSearch", "Types");
        return engine;
    }

    class ViewQueryJob
    extends Job {
        SearchQuery query;
        List<File> temporaryFiles;
        BrowserView browserView;
        Display display;

        public ViewQueryJob(SearchQuery query, List<File> temporaryFiles, BrowserView browserView) {
            super("Search...");
            this.query = query;
            this.temporaryFiles = temporaryFiles;
            this.browserView = browserView;
            this.display = browserView.getBrowser().getDisplay();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor);
                monitor.beginTask("Performing search '" + String.valueOf(this.query) + "'", 10);
                monitor.subTask("Querying index");
                List<QueryResult> result = SearchServiceImpl.createResultPage((IProgressMonitor)mon.newChild(8), this.query, MAX_RESULTS);
                if (result == null) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.worked(8);
                monitor.subTask("Generating results");
                SearchServiceImpl.updatePages(result, this.temporaryFiles);
                monitor.worked(2);
                this.updateBrowser(this.browserView, result.get(0));
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (DatabaseException e1) {
                Status status = new Status(4, "org.simantics.workbench.search.impl", "Unexpected database problems during search result processing, see exception.", (Throwable)e1);
                return status;
            }
            catch (IOException e1) {
                Status status = new Status(4, "org.simantics.workbench.search.impl", "Unexpected I/O problems during search result processing, see exception.", (Throwable)e1);
                return status;
            }
            finally {
                monitor.done();
            }
        }

        void updateBrowser(final BrowserView browserView, QueryResult result) {
            if (this.display.isDisposed()) {
                return;
            }
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (browserView.isDisposed()) {
                        return;
                    }
                    try {
                        long t1 = System.currentTimeMillis();
                        browserView.setUrl(ViewQueryJob.this.temporaryFiles.get(0).toURI().toURL());
                        long t2 = System.currentTimeMillis();
                        System.out.println("Updating UI " + (t2 - t1) + " ms");
                    }
                    catch (MalformedURLException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
            });
        }
    }
}

