/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.Collection;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.BlockingAsyncProcedure;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntryBase;
import org.simantics.db.impl.query.IPending;
import org.simantics.db.impl.query.PendingTaskSupport;
import org.simantics.db.impl.query.Query;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncReadEntry<T>
extends CacheEntryBase<AsyncProcedure<T>>
implements AsyncProcedure<T>,
IPending {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncReadEntry.class);
    protected AsyncRead<T> id;
    protected PendingTaskSupport pendingTaskSupport;

    AsyncReadEntry(AsyncRead<T> request) {
        this.id = request;
    }

    @Override
    int makeHash() {
        return this.id.hashCode();
    }

    @Override
    public Object getOriginalRequest() {
        return this.id;
    }

    @Override
    public void discard() {
        super.discard();
        this.setResult(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void except(AsyncReadGraph graph, Throwable t) {
        assert (this.isPending());
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.except(t);
        }
    }

    @Override
    public final Query getQuery() {
        return new Query(){

            @Override
            public void recompute(ReadGraphImpl graph) {
                try {
                    BlockingAsyncProcedure proc = new BlockingAsyncProcedure(graph, AsyncReadEntry.this, new AsyncProcedure<T>(){

                        public void execute(AsyncReadGraph graph, T result) {
                            AsyncReadEntry.this.setResult(result);
                            AsyncReadEntry.this.setReady();
                        }

                        public void exception(AsyncReadGraph graph, Throwable t) {
                            AsyncReadEntry.this.except(t);
                        }
                    }, AsyncReadEntry.this.id, true);
                    proc.performSync(AsyncReadEntry.this.id);
                }
                catch (Throwable t) {
                    AsyncReadEntry.this.except(t);
                }
            }

            @Override
            public void removeEntry(QueryProcessor qp) {
                qp.cache.remove(AsyncReadEntry.this);
            }

            @Override
            public int type() {
                return AsyncReadEntry.this.id.getFlags();
            }

            public String toString() {
                if (AsyncReadEntry.this.id == null) {
                    return "DISCARDED";
                }
                if (AsyncReadEntry.this.isExcepted()) {
                    return AsyncReadEntry.this.id.toString() + " " + String.valueOf(AsyncReadEntry.this.getResult());
                }
                return AsyncReadEntry.this.id.toString() + " " + String.valueOf(AsyncReadEntry.this.statusOrException);
            }
        };
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, AsyncProcedure<T> proc) {
        if (this.isExcepted()) {
            try {
                proc.exception((AsyncReadGraph)graph, (Throwable)this.getResult());
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.exception failed", t);
            }
        } else {
            try {
                Object result = this.getResult();
                proc.execute((AsyncReadGraph)graph, result);
            }
            catch (Throwable t) {
                LOGGER.error("performFromCache proc.execute failed", t);
            }
        }
        return this.getResult();
    }

    public static <T> T computeForEach(ReadGraphImpl callerGraph, AsyncRead<T> request, AsyncReadEntry<T> entry, AsyncProcedure<T> procedure_, boolean needsToBlock) throws DatabaseException {
        BlockingAsyncProcedure<T> proc = new BlockingAsyncProcedure<T>(callerGraph, entry, procedure_, request, needsToBlock);
        if (needsToBlock) {
            return proc.performSync(request);
        }
        proc.performAsync(request);
        return null;
    }

    public String toString() {
        if (this.isDiscarded()) {
            return "DISCARDED " + this.id.toString();
        }
        if (this.isExcepted()) {
            return this.id.toString() + " " + String.valueOf(this.getResult());
        }
        return this.id.toString() + " " + String.valueOf(this.statusOrException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(AsyncReadGraph graph, T result) {
        Collection<QueryProcessor.SessionTask> tasks = null;
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.setResult(result);
            this.setReady();
            if (this.pendingTaskSupport != null) {
                tasks = this.pendingTaskSupport.executePending();
            }
        }
        if (tasks != null) {
            for (QueryProcessor.SessionTask task : tasks) {
                ((ReadGraphImpl)graph).processor.scheduleNow(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exception(AsyncReadGraph graph, Throwable throwable) {
        Collection<QueryProcessor.SessionTask> tasks = null;
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            this.except(throwable);
            if (this.pendingTaskSupport != null) {
                tasks = this.pendingTaskSupport.executePending();
            }
        }
        if (tasks != null) {
            for (QueryProcessor.SessionTask task : tasks) {
                ((ReadGraphImpl)graph).processor.scheduleNow(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWhenResultIsAvailable(QueryProcessor processor, QueryProcessor.SessionTask task) {
        boolean ready = false;
        AsyncReadEntry asyncReadEntry = this;
        synchronized (asyncReadEntry) {
            if (this.pendingTaskSupport == null) {
                this.pendingTaskSupport = new PendingTaskSupport(this);
            }
            ready = this.pendingTaskSupport.executeWhenResultIsAvailable(task);
        }
        if (ready) {
            processor.scheduleNow(task);
        }
    }

    @Override
    public String classId() {
        return null;
    }
}

