/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.queries;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;

public class Terminal {
    private final Resource component;
    private final Resource relation;
    private final int hash;

    public Terminal(Resource component, Resource relation) {
        this.component = component;
        this.relation = relation;
        this.hash = this.makeHash();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Terminal other = (Terminal)obj;
        return this.component.equals(other.component) && this.relation.equals(other.relation);
    }

    public Resource getComponent() {
        return this.component;
    }

    public Resource getRelation() {
        return this.relation;
    }

    private int makeHash() {
        return this.component.hashCode() + this.relation.hashCode() * 31;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return String.valueOf(this.component) + " " + String.valueOf(this.relation);
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        return NameUtils.getSafeName((ReadGraph)graph, (Resource)this.component) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)this.relation);
    }
}

