/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.application.arguments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.application.arguments.IArgument;
import org.simantics.application.arguments.IArgumentFactory;
import org.simantics.application.arguments.IArguments;

public class Arguments
implements IArguments {
    private Map<String, List<IArgument<?>>> args = new TreeMap();

    @Override
    public void put(IArgument<?> arg) {
        List<IArgument<?>> list = this.args.get(arg.getArgument());
        if (list == null) {
            list = new ArrayList();
            this.args.put(arg.getArgument(), list);
        }
        list.add(arg);
    }

    @Override
    public void putAll(IArguments args) {
        IArgument<?>[] iArgumentArray = args.toArray();
        int n = iArgumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IArgument<?> arg = iArgumentArray[n2];
            this.put(arg);
            ++n2;
        }
    }

    @Override
    public List<IArgument<?>> remove(IArgumentFactory<?> key) {
        return this.args.remove(key.getArgument());
    }

    @Override
    public <T> boolean contains(IArgumentFactory<T> key) {
        return this.args.containsKey(key.getArgument());
    }

    @Override
    public <T> T get(IArgumentFactory<T> key) {
        return this.get(key, null);
    }

    @Override
    public <T> T get(IArgumentFactory<T> key, T defaultValue) {
        List<IArgument<?>> a = this.args.get(key.getArgument());
        if (a == null) {
            return defaultValue;
        }
        if (a.size() == 0) {
            return defaultValue;
        }
        return (T)a.iterator().next().getValue();
    }

    @Override
    public <T> List<T> getAll(IArgumentFactory<T> key) {
        List<IArgument<?>> a = this.args.get(key.getArgument());
        if (a == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (IArgument<?> arg : a) {
            result.add(arg.getValue());
        }
        return result;
    }

    @Override
    public IArgument<?>[] toArray() {
        ArrayList result = new ArrayList();
        for (List<IArgument<?>> l : this.args.values()) {
            result.addAll(l);
        }
        return result.toArray(new IArgument[result.size()]);
    }

    public static IArguments parse(String[] args, IArgumentFactory<?> ... parsedArguments) {
        ListIterator<String> iter = Arrays.asList(args).listIterator();
        Arguments result = new Arguments();
        while (iter.hasNext()) {
            String arg = iter.next();
            IArgument<?> ret = null;
            IArgumentFactory<?>[] iArgumentFactoryArray = parsedArguments;
            int n = parsedArguments.length;
            int n2 = 0;
            while (n2 < n) {
                IArgumentFactory<?> factory = iArgumentFactoryArray[n2];
                try {
                    ret = factory.parse(arg, iter);
                    if (ret != null) {
                        break;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++n2;
            }
            if (ret == null) continue;
            result.put(ret);
        }
        return result;
    }
}

