/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.LayoutUtils;

public class ComparatorSelector
extends Composite {
    Font smallFont;

    public ComparatorSelector(final GraphExplorer explorer, final UserSelectedComparableFactoryQueryProcessor queryProcessor, Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.setLayout((Layout)LayoutUtils.createNoBorderGridLayout((int)1, (boolean)false));
        final Combo combo = new Combo((Composite)this, 8);
        Font initialFont = combo.getFont();
        FontData[] fontData = initialFont.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setHeight(fontData[i].getHeight() - 1);
            ++i;
        }
        this.smallFont = new Font((Device)this.getDisplay(), fontData);
        combo.setFont(this.smallFont);
        combo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        combo.add("-- No comparators --");
        combo.select(0);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                Pair pair = (Pair)combo.getData(String.valueOf(index));
                if (pair == null) {
                    return;
                }
                queryProcessor.select((NodeContext)pair.second, (ComparableContextFactory)pair.first);
            }
        });
        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                NodeContext context = (NodeContext)ISelectionUtils.getSinglePossibleKey((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, NodeContext.class);
                if (context == null) {
                    context = explorer.getRoot();
                }
                if (!$assertionsDisabled && context == null) {
                    throw new AssertionError();
                }
                Collection factories = (Collection)explorer.query(context, (NodeContext.CacheKey)BuiltinKeys.COMPARABLE_FACTORIES);
                if (factories == null) {
                    combo.removeAll();
                    combo.add("-- No comparators --");
                    combo.select(0);
                    return;
                }
                ComparableContextFactory oldSelection = queryProcessor.getComparator(context);
                combo.removeAll();
                if (factories != null) {
                    for (ComparableContextFactory f : factories) {
                        int index = combo.getItemCount();
                        combo.add(f.toString());
                        combo.setData(String.valueOf(index), (Object)new Pair((Object)f, (Object)context));
                        if (f != oldSelection) continue;
                        combo.select(index);
                    }
                }
                if (combo.getItemCount() == 0) {
                    combo.add("-- No comparators --");
                }
                if (combo.getSelectionIndex() == -1) {
                    combo.select(0);
                }
            }
        });
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.smallFont.dispose();
        super.dispose();
    }
}

