/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.validators;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * validates all doubles
 * 
 * @author Toni Kalajainen
 */
public class DoubleValidator implements IInputValidator {

    public static DoubleValidator DOUBLE_VALIDATOR = new DoubleValidator();
    
    public String isValid(String newText) {
        try {
            new Double(newText);
            return null;
        } catch (NumberFormatException e) {
            return "\""+newText+"\" is not a numeric value";//;e.getMessage();
        }       
    }
}
