/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.simantics.utils.datastructures.ArrayMapEntry;
import org.simantics.utils.datastructures.ImmutableIterator;
import org.simantics.utils.datastructures.ImmutableSet;

public class InterlacedArrayMap<K, V>
implements Map<K, V> {
    final Object[] data;
    Set<Map.Entry<K, V>> entrySet;
    Set<K> keySet;
    Collection<V> valueSet;
    private static final int DEFAULT_CAPACITY = 10;

    public static <K, V> InterlacedArrayMapBuilder<K, V> builder() {
        return new InterlacedArrayMapBuilder(10);
    }

    public static <K, V> InterlacedArrayMapBuilder<K, V> builder(int initialCapacity) {
        return new InterlacedArrayMapBuilder(initialCapacity);
    }

    public InterlacedArrayMap(List<?> keysAndValues) {
        this(keysAndValues.toArray());
    }

    public InterlacedArrayMap(Object[] keysAndValues) {
        if ((keysAndValues.length & 1) != 0) {
            throw new IllegalArgumentException("key and value array size (" + keysAndValues.length + ") is not divisible by 2");
        }
        this.data = keysAndValues;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet != null ? this.entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contains(0, key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contains(1, value);
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] == null) {
                    return (V)this.data[i + 1];
                }
                i += 2;
            }
            return null;
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.data.length) {
            Object k = this.data[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                return (V)this.data[i + 1];
            }
            i += 2;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet != null ? this.keySet : (this.keySet = new OffsetSet<K>(0));
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] == null) {
                    Object old = this.data[i + 1];
                    this.data[i + 1] = value;
                    return (V)old;
                }
                i += 2;
            }
            throw new UnsupportedOperationException("key " + String.valueOf(key) + " not present in ArrayMap");
        }
        int hash = key.hashCode();
        int i = 0;
        while (i < this.data.length) {
            Object k = this.data[i];
            if (k == key || hash == k.hashCode() && key.equals(k)) {
                Object old = this.data[i + 1];
                this.data[i + 1] = value;
                return (V)old;
            }
            i += 2;
        }
        throw new UnsupportedOperationException("key " + String.valueOf(key) + " not present in ArrayMap");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (K k : m.keySet()) {
            if (this.containsKey(k)) continue;
            throw new UnsupportedOperationException("key " + String.valueOf(k) + " not present in ArrayMap");
        }
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.data.length >> 1;
    }

    @Override
    public Collection<V> values() {
        return this.valueSet != null ? this.valueSet : (this.valueSet = new OffsetSet<V>(1));
    }

    private boolean contains(int offset, Object o) {
        int len = this.data.length;
        if (o == null) {
            int i = offset;
            while (i < len) {
                if (this.data[i] == null) {
                    return true;
                }
                i += 2;
            }
            return false;
        }
        int hash = o.hashCode();
        int i = offset;
        while (i < len) {
            Object k = this.data[i];
            if (o == k || hash == k.hashCode() && o.equals(k)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int l = this.data.length;
        int i = 0;
        while (i < l) {
            Object key = this.data[i];
            Object value = this.data[i + 1];
            int hash = (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
            h += hash;
            i += 2;
        }
        return h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            int l = this.data.length;
            int i = 0;
            while (true) {
                if (i >= l) {
                    return true;
                }
                Object key = this.data[i];
                Object value = this.data[i + 1];
                if (value == null) {
                    if (m.get(key) != null) return false;
                    if (!m.containsKey(key)) {
                        return false;
                    }
                } else if (!value.equals(m.get(key))) {
                    return false;
                }
                i += 2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    class EntrySet
    extends ImmutableSet<Map.Entry<K, V>>
    implements Set<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return InterlacedArrayMap.this.data.length == 0;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ImmutableIterator<Map.Entry<K, V>>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((EntrySet)EntrySet.this).InterlacedArrayMap.this.data.length;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.i >= ((EntrySet)EntrySet.this).InterlacedArrayMap.this.data.length) {
                        throw new NoSuchElementException("no more elements (" + (((EntrySet)EntrySet.this).InterlacedArrayMap.this.data.length >> 1) + " walked)");
                    }
                    ArrayMapEntry<Object, Object> entry = new ArrayMapEntry<Object, Object>(this.i, ((EntrySet)EntrySet.this).InterlacedArrayMap.this.data[this.i], ((EntrySet)EntrySet.this).InterlacedArrayMap.this.data[this.i + 1]);
                    this.i += 2;
                    return entry;
                }
            };
        }

        @Override
        public int size() {
            return InterlacedArrayMap.this.data.length >> 1;
        }
    }

    public static class InterlacedArrayMapBuilder<K, V> {
        private Object[] elementData;
        private int count = 0;
        private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

        private InterlacedArrayMapBuilder(int initialCapacity) {
            this.elementData = new Object[initialCapacity * 2];
        }

        public void add(K key, V v) {
            this.ensureCapacityInternal(this.count + 2);
            this.elementData[this.count] = key;
            this.elementData[this.count + 1] = v;
            this.count += 2;
        }

        private void ensureCapacityInternal(int minCapacity) {
            if (minCapacity - this.elementData.length > 0) {
                this.grow(minCapacity);
            }
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.elementData.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = InterlacedArrayMapBuilder.hugeCapacity(minCapacity);
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }

        private static int hugeCapacity(int minCapacity) {
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }

        public InterlacedArrayMap<K, V> build() {
            return this.count == this.elementData.length ? new InterlacedArrayMap(this.elementData) : new InterlacedArrayMap(Arrays.copyOf(this.elementData, this.count));
        }
    }

    class OffsetSet<T>
    extends ImmutableSet<T>
    implements Set<T> {
        private final int offset;

        public OffsetSet(int offset) {
            this.offset = offset;
        }

        @Override
        public boolean contains(Object o) {
            return InterlacedArrayMap.this.contains(this.offset, o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return InterlacedArrayMap.this.data.length == 0;
        }

        @Override
        public Iterator<T> iterator() {
            return new ImmutableIterator<T>(){
                int i;
                {
                    this.i = OffsetSet.this.offset;
                }

                @Override
                public boolean hasNext() {
                    return this.i < ((OffsetSet)OffsetSet.this).InterlacedArrayMap.this.data.length;
                }

                @Override
                public T next() {
                    if (this.i >= ((OffsetSet)OffsetSet.this).InterlacedArrayMap.this.data.length) {
                        throw new NoSuchElementException("no more elements (" + ((OffsetSet)OffsetSet.this).InterlacedArrayMap.this.data.length + " walked)");
                    }
                    Object t = ((OffsetSet)OffsetSet.this).InterlacedArrayMap.this.data[this.i];
                    ++this.i;
                    return t;
                }
            };
        }

        @Override
        public int size() {
            return InterlacedArrayMap.this.data.length >> 1;
        }

        @Override
        public Object[] toArray() {
            int len = InterlacedArrayMap.this.data.length >> 1;
            Object[] a = new Object[len];
            int i = 0;
            while (i < len) {
                a[i] = InterlacedArrayMap.this.data[i * 2 + this.offset];
                ++i;
            }
            return a;
        }

        @Override
        public <TT> TT[] toArray(TT[] a) {
            int len = InterlacedArrayMap.this.data.length >> 1;
            if (a.length < len) {
                Class<?> clazz = a.getClass();
                a = clazz == Object[].class ? new Object[len] : (Object[])Array.newInstance(clazz.getComponentType(), len);
            }
            int i = 0;
            while (i < len) {
                a[i] = InterlacedArrayMap.this.data[i * 2 + this.offset];
                ++i;
            }
            if (a.length > len) {
                a[len] = null;
            }
            return a;
        }
    }
}

