package org.simantics.structural.synchronization.client;

import java.util.concurrent.ConcurrentMap;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousSynchronizationJob extends DatabaseJob {

    private static final Logger LOGGER = LoggerFactory.getLogger(ContinuousSynchronizationJob.class);

    public static final String FAMILY = "ContinuousSynchronizationJob";

    private final ConcurrentMap<IExperiment, Job> currentSyncJobs;

    IExperiment                         experiment;

    public ContinuousSynchronizationJob(IExperiment experiment, ConcurrentMap<IExperiment, Job> currentSyncJobs) {
        super("Synchronization");
        this.experiment = experiment;
        this.currentSyncJobs = currentSyncJobs;
        setPriority(SHORT);
        setSystem(false);
    }

    @Override
    public boolean belongsTo(Object family) {
        if (FAMILY == family) return true;
        return super.belongsTo(family);
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        try {
            LOGGER.debug("running ContinuousSynchronizationJob");
            //System.out.println("SYNC #" + (++syncCounter));
            monitor.beginTask("", IProgressMonitor.UNKNOWN);
            if (experiment.getState() != ExperimentState.DISPOSED)
                experiment.refresh(Simantics.getSession());
            LOGGER.debug("finished ContinuousSynchronizationJob");
            return Status.OK_STATUS;
        } catch (Throwable t) {
            LOGGER.error("Failed to refresh experiment", t);
            return new Status(IStatus.ERROR, "org.simantics.structural.synchronization.client", "Failed to refresh experiment "
                    + experiment + " with ID " + experiment.getIdentifier(), t);
        } finally {
            Simantics.getSession().getService(ServiceActivityMonitor.class).unregisterActivity(ContinuousSynchronizationJob.class);
            synchronized(currentSyncJobs) {
                currentSyncJobs.remove(experiment);
            }
            monitor.done();
        }
    }

}
