/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.Simantics;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;

public class Reload
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            RefreshJob j = new RefreshJob(experiment);
            j.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)experiment));
            j.schedule();
        }
        return null;
    }

    static class RefreshJob
    extends Job {
        private final IExperiment experiment;

        public RefreshJob(IExperiment experiment) {
            super("Refresh Experiment");
            this.experiment = experiment;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", -1);
                this.experiment.refresh(Simantics.getSession());
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.simantics.simulation.ui", "Failed to refresh experiment " + String.valueOf(this.experiment) + " with ID " + this.experiment.getIdentifier(), t);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

