/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.g2d.nodes;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.TextUtil;

public class MessageNotificationNode
extends G2DNode {
    private static final long serialVersionUID = -7518450802171689793L;
    private static final Stroke PROGRESS_STROKE = new BasicStroke(1.0f);
    private Rectangle2D bounds;
    private Font font;
    private double margin;
    private double progress;
    private String message;

    @INode.SyncField(value={"bounds", "font", "margin", "progress", "message"})
    public void init(Rectangle2D bounds, Font font, double margin, double progress, String message) {
        this.bounds = bounds;
        this.font = font;
        this.margin = margin;
        this.progress = progress;
        this.message = message;
    }

    @Override
    public void render(Graphics2D g2d) {
        double x = this.bounds.getX();
        double y = this.bounds.getY();
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        double rx = 20.0;
        double ry = 20.0;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double(x, y, width, height, rx, ry);
        Composite oc = g2d.getComposite();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.SrcOver.derive(0.5f));
        g2d.setPaint(Color.BLACK);
        g2d.fill(rr);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.Src);
        g2d.setFont(this.font);
        FontMetrics fm = g2d.getFontMetrics(this.font);
        String[] lines = TextUtil.wordWrap(this.message, fm, (int)(width - 2.0 * this.margin));
        g2d.setColor(Color.WHITE);
        float fh = fm.getHeight() + 1;
        float tx = (float)(x + this.margin);
        float ty = (float)(y + (double)fm.getMaxAscent() + this.margin);
        int i = 0;
        while (i < lines.length) {
            if ((double)(ty + (float)fm.getMaxDescent()) + this.margin > rr.getMaxY()) break;
            g2d.drawString(lines[i], tx, ty);
            ty += fh;
            ++i;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        float c = (float)((double)0.15f + 0.75 * Math.sin(this.progress * Math.PI));
        if (c >= 0.0f && c <= 1.0f) {
            g2d.setComposite(AlphaComposite.getInstance(3, c));
        }
        g2d.setStroke(PROGRESS_STROKE);
        g2d.draw(new Rectangle2D.Double(x + this.margin, y + height - this.margin / 2.0 - 2.0, width - 2.0 * this.margin, this.margin / 2.0));
        g2d.fill(new Rectangle2D.Double(x + this.margin + 2.0, y + height - this.margin / 2.0, (width - 2.0 * this.margin - 4.0) * this.progress, this.margin / 2.0 - 3.0));
        g2d.setComposite(oc);
    }

    @Override
    public String toString() {
        return super.toString() + "[bounds=" + String.valueOf(this.bounds) + ", font=" + String.valueOf(this.font) + ", margin=" + this.margin + ", progress=" + this.progress + ", message=" + this.message + "]";
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }
}

